/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation;

import com.structurizr.Workspace;
import com.structurizr.documentation.Decision;
import com.structurizr.documentation.DecisionStatus;
import com.structurizr.documentation.Format;
import com.structurizr.model.SoftwareSystem;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdrToolsImporter {
    private static final Pattern titleRegex = Pattern.compile("^# \\d*\\. (.*)$", 8);
    private static final Pattern dateRegex = Pattern.compile("^Date: (\\d\\d\\d\\d-\\d\\d-\\d\\d)$", 8);
    private static final Pattern statusRegex = Pattern.compile("## Status\\n\\n(\\w*)");
    private static final String SUPERCEDED_ALTERNATIVE_SPELLING = "Superceded";
    private Workspace workspace;
    private File path;
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");

    public AdrToolsImporter(Workspace workspace, File path) {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be specified.");
        }
        if (path == null) {
            throw new IllegalArgumentException("The path to the architecture decision records must be specified.");
        }
        if (!path.exists()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " does not exist.");
        }
        if (!path.isDirectory()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " is not a directory.");
        }
        this.workspace = workspace;
        this.path = path;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = TimeZone.getTimeZone(timeZone);
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Set<Decision> importArchitectureDecisionRecords() throws Exception {
        return this.importArchitectureDecisionRecords(null);
    }

    public Set<Decision> importArchitectureDecisionRecords(SoftwareSystem softwareSystem) throws Exception {
        HashSet<Decision> decisions = new HashSet<Decision>();
        File[] markdownFiles = this.path.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".md");
            }
        });
        if (markdownFiles != null) {
            HashMap<String, String> index = new HashMap<String, String>();
            for (File file : markdownFiles) {
                index.put(file.getName(), this.extractIntegerIdFromFileName(file));
            }
            for (File file : markdownFiles) {
                String id = this.extractIntegerIdFromFileName(file);
                Date date = new Date();
                String title = "";
                DecisionStatus status = DecisionStatus.Proposed;
                String content = new String(Files.readAllBytes(file.toPath()), "UTF-8");
                content = content.replace("\r", "");
                Format format = Format.Markdown;
                title = this.extractTitle(content);
                date = this.extractDate(content);
                status = this.extractStatus(content);
                for (String filename : index.keySet()) {
                    content = content.replace(filename, this.calculateUrl(softwareSystem, (String)index.get(filename)));
                }
                Decision decision = this.workspace.getDocumentation().addDecision(softwareSystem, id, date, title, status, format, content);
                decisions.add(decision);
            }
        }
        return decisions;
    }

    private String calculateUrl(SoftwareSystem softwareSystem, String id) throws Exception {
        return "#" + this.urlEncode(id);
    }

    private String urlEncode(String value) throws Exception {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20");
    }

    private String extractIntegerIdFromFileName(File file) {
        return "" + Integer.parseInt(file.getName().substring(0, 4));
    }

    private String extractTitle(String content) {
        Matcher matcher = titleRegex.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "Untitled";
    }

    private Date extractDate(String content) throws Exception {
        Matcher matcher = dateRegex.matcher(content);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(this.timeZone);
        if (matcher.find()) {
            return sdf.parse(matcher.group(1));
        }
        return new Date();
    }

    private DecisionStatus extractStatus(String content) {
        Matcher matcher = statusRegex.matcher(content);
        if (matcher.find()) {
            String status = matcher.group(1);
            if (status.equals(SUPERCEDED_ALTERNATIVE_SPELLING)) {
                return DecisionStatus.Superseded;
            }
            return DecisionStatus.valueOf((String)status);
        }
        return DecisionStatus.Proposed;
    }
}

