/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.ComponentFinder;
import com.structurizr.analysis.ComponentFinderStrategy;
import com.structurizr.analysis.JavadocCommentFilter;
import com.structurizr.model.CodeElement;
import com.structurizr.model.CodeElementRole;
import com.structurizr.model.Component;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javadoc.Main;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SourceCodeComponentFinderStrategy
implements ComponentFinderStrategy {
    private ComponentFinder componentFinder;
    private static RootDoc ROOTDOC;
    private File sourcePath;
    private Integer maxDescriptionLength = null;
    private String encoding = null;
    private Map<String, File> typeToSourceFile = new HashMap<String, File>();
    private Map<String, String> typeToDescription = new HashMap<String, String>();

    public SourceCodeComponentFinderStrategy(File sourcePath) {
        this.sourcePath = sourcePath;
    }

    public SourceCodeComponentFinderStrategy(File sourcePath, int maxDescriptionLength) {
        this.sourcePath = sourcePath;
        this.maxDescriptionLength = maxDescriptionLength;
    }

    @Override
    public void setComponentFinder(ComponentFinder componentFinder) {
        this.componentFinder = componentFinder;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void beforeFindComponents() throws Exception {
    }

    @Override
    public Set<Component> findComponents() throws Exception {
        return new HashSet<Component>();
    }

    @Override
    public void afterFindComponents() throws Exception {
        this.runJavaDoc();
        JavadocCommentFilter filter = new JavadocCommentFilter(this.maxDescriptionLength);
        for (ClassDoc classDoc : ROOTDOC.classes()) {
            String type = classDoc.qualifiedTypeName();
            String comment = filter.filterAndTruncate(classDoc.commentText());
            String pathToSourceFile = classDoc.position().file().getCanonicalPath();
            this.typeToSourceFile.put(type, new File(pathToSourceFile));
            this.typeToDescription.put(type, comment);
        }
        for (Component component : this.componentFinder.getContainer().getComponents()) {
            long count = 0L;
            for (CodeElement codeElement : component.getCode()) {
                File sourceFile;
                if (this.typeToDescription.containsKey(codeElement.getType())) {
                    codeElement.setDescription(this.typeToDescription.get(codeElement.getType()));
                    if (codeElement.getRole() == CodeElementRole.Primary && (component.getDescription() == null || component.getDescription().trim().length() == 0)) {
                        component.setDescription(this.typeToDescription.get(component.getType().getType()));
                    }
                }
                if ((sourceFile = this.typeToSourceFile.get(codeElement.getType())) == null) continue;
                long numberOfLinesInFile = Files.lines(Paths.get(sourceFile.toURI())).count();
                codeElement.setUrl(sourceFile.toURI().toString());
                codeElement.setSize(numberOfLinesInFile);
                count += numberOfLinesInFile;
            }
            if (count <= 0L) continue;
            component.setSize(count);
        }
    }

    private void runJavaDoc() throws Exception {
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.add("-sourcepath");
        parameters.add(this.sourcePath.getCanonicalPath());
        parameters.add("-subpackages");
        parameters.add(String.join((CharSequence)":", this.componentFinder.getPackageNames()));
        if (this.encoding != null) {
            parameters.add("-encoding");
            parameters.add(this.encoding);
        }
        parameters.add("-private");
        PrintStream outOriginal = System.out;
        PrintStream errOriginal = System.err;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        System.setOut(new PrintStream(bytes));
        System.setErr(System.out);
        try {
            Main.execute((String)"StructurizrDoclet", (String)this.getClass().getName(), (String[])parameters.toArray(new String[parameters.size()]));
        }
        catch (Throwable t) {
            outOriginal.write(bytes.toByteArray());
            outOriginal.flush();
            throw t;
        }
        finally {
            System.setOut(outOriginal);
            System.setOut(errOriginal);
        }
    }

    public static boolean start(RootDoc rootDoc) {
        ROOTDOC = rootDoc;
        return true;
    }
}

