/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.ComponentFinder;
import com.structurizr.analysis.ComponentFinderStrategy;
import com.structurizr.analysis.DuplicateComponentStrategy;
import com.structurizr.analysis.SupportingTypesStrategy;
import com.structurizr.analysis.ThrowExceptionDuplicateComponentStrategy;
import com.structurizr.analysis.TypeCategory;
import com.structurizr.analysis.TypeRepository;
import com.structurizr.analysis.TypeUtils;
import com.structurizr.analysis.TypeVisibility;
import com.structurizr.model.CodeElement;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractComponentFinderStrategy
implements ComponentFinderStrategy {
    private static final Log log = LogFactory.getLog(AbstractComponentFinderStrategy.class);
    protected Set<Component> componentsFound = new HashSet<Component>();
    protected ComponentFinder componentFinder;
    protected List<SupportingTypesStrategy> supportingTypesStrategies = new ArrayList<SupportingTypesStrategy>();
    private DuplicateComponentStrategy duplicateComponentStrategy = new ThrowExceptionDuplicateComponentStrategy();

    protected AbstractComponentFinderStrategy(SupportingTypesStrategy ... strategies) {
        Arrays.stream(strategies).forEach(this::addSupportingTypesStrategy);
    }

    protected ComponentFinder getComponentFinder() {
        return this.componentFinder;
    }

    @Override
    public void setComponentFinder(ComponentFinder componentFinder) {
        this.componentFinder = componentFinder;
    }

    protected TypeRepository getTypeRepository() {
        return this.componentFinder.getTypeRepository();
    }

    @Override
    public void beforeFindComponents() {
        this.supportingTypesStrategies.forEach(sts -> sts.setTypeRepository(this.getTypeRepository()));
    }

    @Override
    public Set<Component> findComponents() {
        this.componentsFound.addAll(this.doFindComponents());
        return this.componentsFound;
    }

    protected abstract Set<Component> doFindComponents();

    @Override
    public void afterFindComponents() {
        this.findSupportingTypes(this.componentsFound);
        this.findDependencies();
    }

    protected void findSupportingTypes(Set<Component> components) {
        for (Component component : components) {
            for (CodeElement codeElement : component.getCode()) {
                TypeCategory category;
                TypeVisibility visibility = TypeUtils.getVisibility(this.getTypeRepository(), codeElement.getType());
                if (visibility != null) {
                    codeElement.setVisibility(visibility.getName());
                }
                if ((category = TypeUtils.getCategory(this.getTypeRepository(), codeElement.getType())) == null) continue;
                codeElement.setCategory(category.getName());
            }
            for (SupportingTypesStrategy strategy : this.supportingTypesStrategies) {
                for (Class<?> type : strategy.findSupportingTypes(component)) {
                    TypeCategory category;
                    if (this.isNestedClass(type) || this.findComponent(type.getCanonicalName()) != null) continue;
                    CodeElement codeElement = component.addSupportingType(type.getCanonicalName());
                    TypeVisibility visibility = TypeUtils.getVisibility(this.getTypeRepository(), codeElement.getType());
                    if (visibility != null) {
                        codeElement.setVisibility(visibility.getName());
                    }
                    if ((category = TypeUtils.getCategory(this.getTypeRepository(), codeElement.getType())) == null) continue;
                    codeElement.setCategory(category.getName());
                }
            }
        }
    }

    private boolean isNestedClass(Class<?> type) {
        return type != null && type.getName().indexOf(36) > -1;
    }

    protected void findDependencies() {
        for (Component component : this.componentFinder.getContainer().getComponents()) {
            for (CodeElement codeElement : component.getCode()) {
                this.addEfferentDependencies(component, codeElement.getType(), new HashSet<String>());
            }
        }
    }

    private void addEfferentDependencies(Component component, String type, Set<String> typesVisited) {
        typesVisited.add(type);
        for (Class<?> referencedType : this.getTypeRepository().findReferencedTypes(type)) {
            try {
                String referencedTypeName;
                if (this.isNestedClass(referencedType) || StringUtils.isNullOrEmpty((String)(referencedTypeName = referencedType.getCanonicalName()))) continue;
                Component destinationComponent = this.findComponent(referencedTypeName);
                if (destinationComponent != null) {
                    if (component == destinationComponent) continue;
                    component.uses(destinationComponent, "");
                    continue;
                }
                if (typesVisited.contains(referencedTypeName)) continue;
                this.addEfferentDependencies(component, referencedTypeName, typesVisited);
            }
            catch (Throwable t) {
                log.warn((Object)t);
            }
        }
    }

    private Component findComponent(String referencedTypeName) {
        Container container = this.componentFinder.getContainer();
        Component componentOfType = container.getComponentOfType(referencedTypeName);
        if (componentOfType == null) {
            componentOfType = container.getComponentWithName(referencedTypeName);
        }
        return componentOfType;
    }

    public void addSupportingTypesStrategy(SupportingTypesStrategy supportingTypesStrategy) {
        if (supportingTypesStrategy == null) {
            throw new IllegalArgumentException("A supporting types strategy must be provided.");
        }
        this.supportingTypesStrategies.add(supportingTypesStrategy);
    }

    protected Set<Class<?>> findTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return TypeUtils.findTypesAnnotatedWith(annotation, this.getTypeRepository().getAllTypes());
    }

    protected Set<Component> findClassesWithAnnotation(Class<? extends Annotation> type, String technology) {
        return this.findClassesWithAnnotation(type, technology, false);
    }

    protected Set<Component> findClassesWithAnnotation(Class<? extends Annotation> type, String technology, boolean includePublicTypesOnly) {
        HashSet<Component> components = new HashSet<Component>();
        Set<Class<?>> componentTypes = this.findTypesAnnotatedWith(type);
        for (Class<?> componentType : componentTypes) {
            Container container;
            Component newComponent;
            if (includePublicTypesOnly && !Modifier.isPublic(componentType.getModifiers()) || (newComponent = this.addComponent(container = this.getComponentFinder().getContainer(), componentType.getSimpleName(), componentType.getCanonicalName(), "", technology)) == null) continue;
            components.add(newComponent);
        }
        return components;
    }

    public DuplicateComponentStrategy getDuplicateComponentStrategy() {
        return this.duplicateComponentStrategy;
    }

    public void setDuplicateComponentStrategy(DuplicateComponentStrategy duplicateComponentStrategy) {
        this.duplicateComponentStrategy = duplicateComponentStrategy != null ? duplicateComponentStrategy : new ThrowExceptionDuplicateComponentStrategy();
    }

    protected Component addComponent(Container container, String name, String type, String description, String technology) {
        if (container.getComponentWithName(name) == null) {
            return container.addComponent(name, type, description, technology);
        }
        return this.duplicateComponentStrategy.duplicateComponentFound(container.getComponentWithName(name), name, type, description, technology);
    }
}

