/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.google.common.base.Predicate;
import com.structurizr.analysis.AbstractComponentFinderStrategy;
import com.structurizr.analysis.DuplicateComponentStrategy;
import com.structurizr.analysis.IgnoreDuplicateComponentStrategy;
import com.structurizr.analysis.ReferencedTypesSupportingTypesStrategy;
import com.structurizr.analysis.SupportingTypesStrategy;
import com.structurizr.analysis.TypeUtils;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reflections.ReflectionUtils;

public class AnnotatedMethodComponentFinderStrategy
extends AbstractComponentFinderStrategy {
    private final Class<? extends Annotation> classAnnotation;
    private final Class<? extends Annotation> methodAnnotation;

    public AnnotatedMethodComponentFinderStrategy(Class<? extends Annotation> methodAnnotation) {
        this(methodAnnotation, null, new IgnoreDuplicateComponentStrategy(), new SupportingTypesStrategy[0]);
    }

    public AnnotatedMethodComponentFinderStrategy(Class<? extends Annotation> methodAnnotation, DuplicateComponentStrategy duplicateComponentStrategy) {
        this(methodAnnotation, null, duplicateComponentStrategy, new SupportingTypesStrategy[0]);
    }

    public AnnotatedMethodComponentFinderStrategy(Class<? extends Annotation> methodAnnotation, Class<? extends Annotation> classAnnotation) {
        this(methodAnnotation, classAnnotation, new IgnoreDuplicateComponentStrategy(), new ReferencedTypesSupportingTypesStrategy());
    }

    public AnnotatedMethodComponentFinderStrategy(@Nonnull Class<? extends Annotation> methodAnnotation, @Nullable Class<? extends Annotation> classAnnotation, @Nullable DuplicateComponentStrategy duplicateComponentStrategy, SupportingTypesStrategy ... strategies) {
        super(strategies);
        DuplicateComponentStrategy duplicateStrategy = duplicateComponentStrategy != null ? duplicateComponentStrategy : new IgnoreDuplicateComponentStrategy();
        this.setDuplicateComponentStrategy(duplicateStrategy);
        this.classAnnotation = classAnnotation;
        this.methodAnnotation = methodAnnotation;
    }

    @Override
    protected Set<Component> doFindComponents() {
        HashSet<Component> components = new HashSet<Component>();
        Container container = this.getComponentFinder().getContainer();
        HashSet classes = new HashSet();
        if (this.classAnnotation != null) {
            classes.addAll(this.findTypesAnnotatedWith(this.classAnnotation));
        } else {
            classes.addAll(this.getComponentFinder().getTypeRepository().getAllTypes());
        }
        for (Class clazz : classes) {
            Set allMethods = ReflectionUtils.getAllMethods((Class)clazz, (Predicate[])new Predicate[]{m -> m.isAnnotationPresent(this.methodAnnotation)}).stream().map(this::interfaceToImpReturnedFrom).filter(Objects::nonNull).collect(Collectors.toSet());
            for (AbstractMap.SimpleImmutableEntry entry : allMethods) {
                Component component = this.addComponent(container, ((Class)entry.getKey()).getSimpleName(), ((Class)entry.getValue()).getName(), "", "");
                if (component == null) continue;
                components.add(component);
            }
        }
        return components;
    }

    private AbstractMap.SimpleImmutableEntry<Class, Class> interfaceToImpReturnedFrom(Method method) {
        Class firstImplementationOfInterface;
        Class<?> returnInterface = method.getReturnType();
        if (returnInterface.equals(Void.TYPE)) {
            return null;
        }
        Class returnFirstImpl = method.getReturnType();
        if (returnInterface.isInterface() && (firstImplementationOfInterface = TypeUtils.findFirstImplementationOfInterface(returnInterface, this.getTypeRepository().getAllTypes())) != null) {
            returnFirstImpl = firstImplementationOfInterface;
        }
        return new AbstractMap.SimpleImmutableEntry<Class, Class>(returnInterface, returnFirstImpl);
    }
}

