/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.google.common.base.Predicate;
import com.structurizr.analysis.TypeRepository;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.AbstractScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class DefaultTypeRepository
implements TypeRepository {
    private static final Log log = LogFactory.getLog(DefaultTypeRepository.class);
    private final Set<Class<?>> types;
    private final ClassLoader classLoader;
    private List<String> packagesToScan;
    private Set<Pattern> exclusions = new HashSet<Pattern>();
    private ClassPool classPool;
    private Map<String, Set<Class<?>>> referencedTypesCache = new HashMap();

    DefaultTypeRepository(String packageToScan, Set<Pattern> exclusions, URLClassLoader urlClassLoader) {
        this(Arrays.asList(packageToScan), exclusions, urlClassLoader);
    }

    DefaultTypeRepository(List<String> packagesToScan, Set<Pattern> exclusions, URLClassLoader urlClassLoader) {
        List<URL> urls;
        if (urlClassLoader == null) {
            this.classLoader = ClassLoader.getSystemClassLoader();
            urls = ClasspathHelper.forJavaClassPath();
            this.classPool = ClassPool.getDefault();
        } else {
            this.classLoader = urlClassLoader;
            urls = Arrays.asList(urlClassLoader.getURLs());
            this.classPool = new ClassPool();
            this.classPool.insertClassPath((ClassPath)new LoaderClassPath((ClassLoader)urlClassLoader));
        }
        this.packagesToScan = packagesToScan;
        if (exclusions != null) {
            this.exclusions.addAll(exclusions);
        }
        AllTypesScanner allTypesScanner = new AllTypesScanner();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(urls).filterInputsBy((Predicate)new FilterBuilder().includePackage(packagesToScan.toArray(new String[packagesToScan.size()]))).setScanners(new Scanner[]{new SubTypesScanner(false), allTypesScanner}));
        this.types = new HashSet();
        this.types.addAll(ReflectionUtils.forNames(allTypesScanner.types, (ClassLoader[])new ClassLoader[]{this.classLoader}));
    }

    @Override
    public Class<?> loadClass(String typeName) throws ClassNotFoundException {
        return this.classLoader.loadClass(typeName);
    }

    @Override
    public List<String> getPackages() {
        return this.packagesToScan;
    }

    @Override
    public Set<Class<?>> getAllTypes() {
        return new HashSet(this.types);
    }

    @Override
    public Set<Class<?>> findReferencedTypes(String typeName) {
        HashSet referencedTypes = new HashSet();
        if (this.referencedTypesCache.containsKey(typeName)) {
            return this.referencedTypesCache.get(typeName);
        }
        try {
            CtClass cc = this.classPool.get(typeName);
            for (Object referencedType : cc.getRefClasses()) {
                String referencedTypeName = (String)referencedType;
                if (this.isExcluded(referencedTypeName)) continue;
                try {
                    referencedTypes.add(this.loadClass(referencedTypeName));
                }
                catch (Throwable t) {
                    log.debug((Object)("Could not find " + referencedTypeName + " ... ignoring."));
                }
            }
            referencedTypes.remove(this.loadClass(typeName));
        }
        catch (Exception e) {
            log.debug((Object)("Error finding referenced types for " + typeName + " ... ignoring."));
            this.referencedTypesCache.put(typeName, new HashSet());
        }
        this.referencedTypesCache.put(typeName, referencedTypes);
        return referencedTypes;
    }

    private Set<Class<?>> filter(Set<Class<?>> types) {
        return types.stream().filter((? super T c) -> !this.isExcluded(c.getCanonicalName())).collect(Collectors.toSet());
    }

    private boolean isExcluded(String typeName) {
        if (typeName == null) {
            return true;
        }
        for (Pattern exclude : this.exclusions) {
            if (!exclude.matcher(typeName).matches()) continue;
            return true;
        }
        return false;
    }

    class AllTypesScanner
    extends AbstractScanner {
        Set<String> types = new HashSet<String>();

        AllTypesScanner() {
        }

        public void scan(Object cls) {
            String typeName = this.getMetadataAdapter().getClassName(cls);
            if (!DefaultTypeRepository.this.isExcluded(typeName)) {
                this.types.add(typeName);
            }
        }
    }
}

