/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.autolayout.graphviz;

import com.structurizr.autolayout.graphviz.DOTDiagram;
import com.structurizr.autolayout.graphviz.RankDirection;
import com.structurizr.autolayout.graphviz.StyleUtils;
import com.structurizr.export.AbstractDiagramExporter;
import com.structurizr.export.Diagram;
import com.structurizr.export.IndentingWriter;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.ModelView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import java.util.Locale;

class DOTExporter
extends AbstractDiagramExporter {
    private static final String DEFAULT_CLUSTER_INTERNAL_PADDING = "25";
    private static final String GROUP_PADDING_PROPERTY_NAME = "structurizr.groupPadding";
    private static final String BOUNDARY_PADDING_PROPERTY_NAME = "structurizr.boundaryPadding";
    private static final String DEPLOYMENT_NODE_PADDING_PROPERTY_NAME = "structurizr.deploymentNodePadding";
    private Locale locale = Locale.US;
    private final RankDirection rankDirection;
    private final double rankSeparation;
    private final double nodeSeparation;
    private int groupId = 1;

    DOTExporter(RankDirection rankDirection, double rankSeparation, double nodeSeparation) {
        this.rankDirection = rankDirection != null ? rankDirection : RankDirection.TopBottom;
        this.rankSeparation = rankSeparation / 300.0;
        this.nodeSeparation = nodeSeparation / 300.0;
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected void writeHeader(ModelView view, IndentingWriter writer) {
        writer.writeLine("digraph {");
        writer.indent();
        writer.writeLine("compound=true");
        writer.writeLine(String.format(this.locale, "graph [splines=polyline,rankdir=%s,ranksep=%s,nodesep=%s,fontsize=5]", this.rankDirection.getCode(), this.rankSeparation, this.nodeSeparation));
        writer.writeLine("node [shape=box,fontsize=5]");
        writer.writeLine("edge []");
        writer.writeLine();
    }

    protected void writeFooter(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
    }

    protected void startGroupBoundary(ModelView view, String group, IndentingWriter writer) {
        writer.writeLine("subgraph \"cluster_group_" + this.groupId++ + "\" {");
        writer.indent();
        writer.writeLine("margin=" + Integer.parseInt(this.getViewOrViewSetProperty(view, GROUP_PADDING_PROPERTY_NAME, DEFAULT_CLUSTER_INTERNAL_PADDING)));
    }

    protected void endGroupBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    protected void startSoftwareSystemBoundary(ModelView view, SoftwareSystem softwareSystem, IndentingWriter writer) {
        writer.writeLine(String.format("subgraph cluster_%s {", softwareSystem.getId()));
        writer.indent();
        writer.writeLine("margin=" + Integer.parseInt(this.getViewOrViewSetProperty(view, BOUNDARY_PADDING_PROPERTY_NAME, DEFAULT_CLUSTER_INTERNAL_PADDING)));
    }

    protected void endSoftwareSystemBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    protected void startContainerBoundary(ModelView view, Container container, IndentingWriter writer) {
        writer.writeLine(String.format("subgraph cluster_%s {", container.getId()));
        writer.indent();
        writer.writeLine("margin=" + Integer.parseInt(this.getViewOrViewSetProperty(view, BOUNDARY_PADDING_PROPERTY_NAME, DEFAULT_CLUSTER_INTERNAL_PADDING)));
    }

    protected void endContainerBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    protected void startDeploymentNodeBoundary(DeploymentView view, DeploymentNode deploymentNode, IndentingWriter writer) {
        writer.writeLine(String.format("subgraph cluster_%s {", deploymentNode.getId()));
        writer.indent();
        writer.writeLine("margin=" + Integer.parseInt(this.getViewOrViewSetProperty((ModelView)view, DEPLOYMENT_NODE_PADDING_PROPERTY_NAME, DEFAULT_CLUSTER_INTERNAL_PADDING)));
    }

    protected void endDeploymentNodeBoundary(ModelView view, IndentingWriter writer) {
        writer.outdent();
        writer.writeLine("}");
        writer.writeLine();
    }

    protected void writeElement(ModelView view, Element element, IndentingWriter writer) {
        ElementStyle elementStyle = StyleUtils.findElementStyle((View)view, element);
        writer.writeLine(String.format(this.locale, "%s [width=%f,height=%f,fixedsize=true,id=%s,label=\"%s: %s\"]", element.getId(), (double)elementStyle.getWidth().intValue() / 300.0, (double)elementStyle.getHeight().intValue() / 300.0, element.getId(), element.getId(), this.escape(element.getName())));
    }

    protected void writeRelationship(ModelView view, RelationshipView relationshipView, IndentingWriter writer) {
        if (relationshipView.getRelationship().getSource() instanceof DeploymentNode || relationshipView.getRelationship().getDestination() instanceof DeploymentNode) {
            Element destination;
            Element source = relationshipView.getRelationship().getSource();
            if (source instanceof DeploymentNode) {
                source = this.findElementInside((DeploymentNode)source, view);
            }
            if ((destination = relationshipView.getRelationship().getDestination()) instanceof DeploymentNode) {
                destination = this.findElementInside((DeploymentNode)destination, view);
            }
            if (source != null && destination != null) {
                Object clusterConfig = "";
                if (relationshipView.getRelationship().getSource() instanceof DeploymentNode) {
                    clusterConfig = (String)clusterConfig + ",ltail=cluster_" + relationshipView.getRelationship().getSource().getId();
                }
                if (relationshipView.getRelationship().getDestination() instanceof DeploymentNode) {
                    clusterConfig = (String)clusterConfig + ",lhead=cluster_" + relationshipView.getRelationship().getDestination().getId();
                }
                writer.writeLine(String.format(this.locale, "%s -> %s [id=%s%s]", source.getId(), destination.getId(), relationshipView.getId(), clusterConfig));
            }
        } else {
            Element source = relationshipView.getRelationship().getSource();
            Element destination = relationshipView.getRelationship().getDestination();
            if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                source = relationshipView.getRelationship().getDestination();
                destination = relationshipView.getRelationship().getSource();
            }
            writer.writeLine(String.format(this.locale, "%s -> %s [id=%s]", source.getId(), destination.getId(), relationshipView.getId()));
        }
    }

    protected Diagram createDiagram(ModelView view, String definition) {
        return new DOTDiagram(view, definition);
    }

    private String escape(String s) {
        if (StringUtils.isNullOrEmpty((String)s)) {
            return s;
        }
        return s.replaceAll("\"", "\\\\\"");
    }

    private Element findElementInside(DeploymentNode deploymentNode, ModelView view) {
        for (SoftwareSystemInstance softwareSystemInstance : deploymentNode.getSoftwareSystemInstances()) {
            if (!view.isElementInView((Element)softwareSystemInstance)) continue;
            return softwareSystemInstance;
        }
        for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
            if (!view.isElementInView((Element)containerInstance)) continue;
            return containerInstance;
        }
        for (InfrastructureNode infrastructureNode : deploymentNode.getInfrastructureNodes()) {
            if (!view.isElementInView((Element)infrastructureNode)) continue;
            return infrastructureNode;
        }
        if (deploymentNode.hasChildren()) {
            for (DeploymentNode child : deploymentNode.getChildren()) {
                Element element = this.findElementInside(child, view);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }
}

