/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.structurizr.Workspace;
import com.structurizr.io.WorkspaceWriterException;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.Theme;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public final class ThemeUtils {
    private static final int HTTP_OK_STATUS = 200;

    public static void toJson(Workspace workspace, File file) throws Exception {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        if (file == null) {
            throw new IllegalArgumentException("The path to a file must be specified.");
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        ThemeUtils.write(workspace, writer);
    }

    public static String toJson(Workspace workspace) throws Exception {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        StringWriter writer = new StringWriter();
        ThemeUtils.write(workspace, writer);
        return writer.toString();
    }

    public static void loadThemes(Workspace workspace) throws Exception {
        for (String url : workspace.getViews().getConfiguration().getThemes()) {
            HttpGet httpGet;
            CloseableHttpClient httpClient = HttpClients.createSystem();
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)(httpGet = new HttpGet(url)));
            if (response.getCode() == 200) {
                String json = EntityUtils.toString((HttpEntity)response.getEntity());
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
                objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                Theme theme = (Theme)objectMapper.readValue(json, Theme.class);
                String baseUrl = url.substring(0, url.lastIndexOf(47) + 1);
                for (ElementStyle elementStyle : theme.getElements()) {
                    String icon = elementStyle.getIcon();
                    if (StringUtils.isNullOrEmpty((String)icon) || icon.startsWith("http") || icon.startsWith("data:image")) continue;
                    elementStyle.setIcon(baseUrl + icon);
                }
                workspace.getViews().getConfiguration().getStyles().addStylesFromTheme(theme);
            }
            httpClient.close();
        }
    }

    private static void write(Workspace workspace, Writer writer) throws Exception {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            Theme theme = new Theme(workspace.getName(), workspace.getDescription(), workspace.getViews().getConfiguration().getStyles().getElements(), workspace.getViews().getConfiguration().getStyles().getRelationships());
            theme.setFont(workspace.getViews().getConfiguration().getBranding().getFont());
            theme.setLogo(workspace.getViews().getConfiguration().getBranding().getLogo());
            writer.write(objectMapper.writeValueAsString((Object)theme));
        }
        catch (IOException ioe) {
            throw new WorkspaceWriterException("Could not write the theme as JSON", ioe);
        }
        writer.flush();
        writer.close();
    }
}

