/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.api;

import com.structurizr.Workspace;
import com.structurizr.api.ApiResponse;
import com.structurizr.api.HashBasedMessageAuthenticationCode;
import com.structurizr.api.HmacAuthorizationHeader;
import com.structurizr.api.HmacContent;
import com.structurizr.api.Md5Digest;
import com.structurizr.api.StructurizrClientException;
import com.structurizr.encryption.EncryptedWorkspace;
import com.structurizr.encryption.EncryptionLocation;
import com.structurizr.encryption.EncryptionStrategy;
import com.structurizr.io.json.EncryptedJsonReader;
import com.structurizr.io.json.EncryptedJsonWriter;
import com.structurizr.io.json.JsonReader;
import com.structurizr.io.json.JsonWriter;
import com.structurizr.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;

public final class StructurizrClient {
    private static final Log log = LogFactory.getLog(StructurizrClient.class);
    private static final String VERSION = Package.getPackage("com.structurizr.api").getImplementationVersion();
    private static final String STRUCTURIZR_FOR_JAVA_AGENT = "structurizr-java/" + VERSION;
    private static final String STRUCTURIZR_CLOUD_API_URL = "https://api.structurizr.com";
    private static final String STRUCTURIZR_API_URL = "structurizr.api.url";
    private static final String STRUCTURIZR_API_KEY = "structurizr.api.key";
    private static final String STRUCTURIZR_API_SECRET = "structurizr.api.secret";
    private static final String WORKSPACE_PATH = "/workspace/";
    private String url;
    private String apiKey;
    private String apiSecret;
    private EncryptionStrategy encryptionStrategy;
    private boolean mergeFromRemote;
    private File workspaceArchiveLocation;

    public StructurizrClient() throws StructurizrClientException {
        block15: {
            this.mergeFromRemote = true;
            this.workspaceArchiveLocation = new File(".");
            try (InputStream in = StructurizrClient.class.getClassLoader().getResourceAsStream("structurizr.properties");){
                Properties properties = new Properties();
                if (in != null) {
                    properties.load(in);
                    this.setUrl(properties.getProperty(STRUCTURIZR_API_URL));
                    this.setApiKey(properties.getProperty(STRUCTURIZR_API_KEY));
                    this.setApiSecret(properties.getProperty(STRUCTURIZR_API_SECRET));
                    break block15;
                }
                throw new StructurizrClientException("Could not find a structurizr.properties file on the classpath.");
            }
            catch (IOException e) {
                log.error((Object)e);
                throw new StructurizrClientException(e);
            }
        }
    }

    public StructurizrClient(String apiKey, String apiSecret) {
        this(STRUCTURIZR_CLOUD_API_URL, apiKey, apiSecret);
    }

    public StructurizrClient(String url, String apiKey, String apiSecret) {
        this.mergeFromRemote = true;
        this.workspaceArchiveLocation = new File(".");
        this.setUrl(url);
        this.setApiKey(apiKey);
        this.setApiSecret(apiSecret);
    }

    public String getUrl() {
        return this.url;
    }

    private void setUrl(String url) {
        if (url == null || url.trim().length() == 0) {
            throw new IllegalArgumentException("The API URL must not be null or empty.");
        }
        this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    String getApiKey() {
        return this.apiKey;
    }

    private void setApiKey(String apiKey) {
        if (apiKey == null || apiKey.trim().length() == 0) {
            throw new IllegalArgumentException("The API key must not be null or empty.");
        }
        this.apiKey = apiKey;
    }

    String getApiSecret() {
        return this.apiSecret;
    }

    private void setApiSecret(String apiSecret) {
        if (apiSecret == null || apiSecret.trim().length() == 0) {
            throw new IllegalArgumentException("The API secret must not be null or empty.");
        }
        this.apiSecret = apiSecret;
    }

    public File getWorkspaceArchiveLocation() {
        return this.workspaceArchiveLocation;
    }

    public void setWorkspaceArchiveLocation(File workspaceArchiveLocation) {
        this.workspaceArchiveLocation = workspaceArchiveLocation;
    }

    public void setEncryptionStrategy(EncryptionStrategy encryptionStrategy) {
        this.encryptionStrategy = encryptionStrategy;
    }

    public void setMergeFromRemote(boolean mergeFromRemote) {
        this.mergeFromRemote = mergeFromRemote;
    }

    public boolean lockWorkspace(long workspaceId) throws StructurizrClientException {
        return this.manageLockForWorkspace(workspaceId, true);
    }

    public boolean unlockWorkspace(long workspaceId) throws StructurizrClientException {
        return this.manageLockForWorkspace(workspaceId, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean manageLockForWorkspace(long workspaceId, boolean lock) throws StructurizrClientException {
        if (workspaceId <= 0L) {
            throw new IllegalArgumentException("The workspace ID must be a positive integer.");
        }
        try (CloseableHttpClient httpClient = HttpClients.createSystem();){
            ApiResponse apiResponse;
            Throwable throwable;
            CloseableHttpResponse response;
            block28: {
                boolean bl;
                block29: {
                    HttpPut httpRequest;
                    if (lock) {
                        log.info((Object)("Locking workspace with ID " + workspaceId));
                        httpRequest = new HttpPut(this.url + WORKSPACE_PATH + workspaceId + "/lock?user=" + this.getUser() + "&agent=" + STRUCTURIZR_FOR_JAVA_AGENT);
                    } else {
                        log.info((Object)("Unlocking workspace with ID " + workspaceId));
                        httpRequest = new HttpDelete(this.url + WORKSPACE_PATH + workspaceId + "/lock?user=" + this.getUser() + "&agent=" + STRUCTURIZR_FOR_JAVA_AGENT);
                    }
                    this.addHeaders((HttpUriRequestBase)httpRequest, "", "");
                    this.debugRequest((HttpUriRequestBase)httpRequest, null);
                    response = httpClient.execute((ClassicHttpRequest)httpRequest);
                    throwable = null;
                    this.debugResponse(response);
                    String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                    apiResponse = ApiResponse.parse(responseText);
                    log.info((Object)responseText);
                    if (response.getCode() != 200) break block28;
                    bl = apiResponse.isSuccess();
                    if (response == null) return bl;
                    if (throwable == null) break block29;
                    try {
                        response.close();
                        return bl;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return bl;
                    }
                }
                response.close();
                return bl;
            }
            try {
                try {
                    throw new StructurizrClientException(apiResponse.getMessage());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (response == null) throw throwable4;
                if (throwable == null) {
                    response.close();
                    throw throwable4;
                }
                try {
                    response.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new StructurizrClientException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Workspace getWorkspace(long workspaceId) throws StructurizrClientException {
        if (workspaceId <= 0L) {
            throw new IllegalArgumentException("The workspace ID must be a positive integer.");
        }
        try {
            Throwable throwable;
            CloseableHttpResponse response;
            CloseableHttpClient httpClient = HttpClients.createSystem();
            Throwable throwable2 = null;
            try {
                String json;
                block42: {
                    block43: {
                        Workspace workspace;
                        block44: {
                            log.info((Object)("Getting workspace with ID " + workspaceId));
                            HttpGet httpGet = new HttpGet(this.url + WORKSPACE_PATH + workspaceId);
                            this.addHeaders((HttpUriRequestBase)httpGet, "", "");
                            this.debugRequest((HttpUriRequestBase)httpGet, null);
                            response = httpClient.execute((ClassicHttpRequest)httpGet);
                            throwable = null;
                            this.debugResponse(response);
                            json = EntityUtils.toString((HttpEntity)response.getEntity());
                            if (response.getCode() != 200) break block42;
                            this.archiveWorkspace(workspaceId, json);
                            if (this.encryptionStrategy != null) break block43;
                            workspace = new JsonReader().read(new StringReader(json));
                            if (response == null) return workspace;
                            if (throwable == null) break block44;
                            try {
                                response.close();
                                return workspace;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                                return workspace;
                            }
                        }
                        response.close();
                        return workspace;
                    }
                    EncryptedWorkspace encryptedWorkspace = new EncryptedJsonReader().read(new StringReader(json));
                    if (encryptedWorkspace.getEncryptionStrategy() != null) {
                        encryptedWorkspace.getEncryptionStrategy().setPassphrase(this.encryptionStrategy.getPassphrase());
                        Workspace workspace = encryptedWorkspace.getWorkspace();
                        return workspace;
                    }
                    Workspace workspace = new JsonReader().read(new StringReader(json));
                    return workspace;
                }
                try {
                    ApiResponse apiResponse = ApiResponse.parse(json);
                    throw new StructurizrClientException(apiResponse.getMessage());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            {
                finally {
                    if (response != null) {
                        if (throwable != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            response.close();
                        }
                    }
                }
            }
            finally {
                if (httpClient != null) {
                    if (throwable2 != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                    } else {
                        httpClient.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new StructurizrClientException(e);
        }
    }

    public void putWorkspace(long workspaceId, Workspace workspace) throws StructurizrClientException {
        block32: {
            if (workspace == null) {
                throw new IllegalArgumentException("The workspace must not be null.");
            }
            if (workspaceId <= 0L) {
                throw new IllegalArgumentException("The workspace ID must be a positive integer.");
            }
            try (CloseableHttpClient httpClient = HttpClients.createSystem();){
                Workspace remoteWorkspace;
                if (this.mergeFromRemote && (remoteWorkspace = this.getWorkspace(workspaceId)) != null) {
                    workspace.getViews().copyLayoutInformationFrom(remoteWorkspace.getViews());
                    workspace.getViews().getConfiguration().copyConfigurationFrom(remoteWorkspace.getViews().getConfiguration());
                }
                workspace.setId(workspaceId);
                workspace.setThumbnail(null);
                workspace.setLastModifiedDate(new Date());
                workspace.setLastModifiedAgent(STRUCTURIZR_FOR_JAVA_AGENT);
                workspace.setLastModifiedUser(this.getUser());
                workspace.countAndLogWarnings();
                HttpPut httpPut = new HttpPut(this.url + WORKSPACE_PATH + workspaceId);
                StringWriter stringWriter = new StringWriter();
                if (this.encryptionStrategy == null) {
                    JsonWriter jsonWriter = new JsonWriter(false);
                    jsonWriter.write(workspace, stringWriter);
                } else {
                    EncryptedWorkspace encryptedWorkspace = new EncryptedWorkspace(workspace, this.encryptionStrategy);
                    this.encryptionStrategy.setLocation(EncryptionLocation.Client);
                    EncryptedJsonWriter jsonWriter = new EncryptedJsonWriter(false);
                    jsonWriter.write(encryptedWorkspace, stringWriter);
                }
                StringEntity stringEntity = new StringEntity(stringWriter.toString(), ContentType.APPLICATION_JSON);
                httpPut.setEntity((HttpEntity)stringEntity);
                this.addHeaders((HttpUriRequestBase)httpPut, EntityUtils.toString((HttpEntity)stringEntity), ContentType.APPLICATION_JSON.toString());
                this.debugRequest((HttpUriRequestBase)httpPut, EntityUtils.toString((HttpEntity)stringEntity));
                log.info((Object)("Putting workspace with ID " + workspaceId));
                try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpPut);){
                    String json = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (response.getCode() == 200) {
                        this.debugResponse(response);
                        log.info((Object)json);
                        break block32;
                    }
                    ApiResponse apiResponse = ApiResponse.parse(json);
                    throw new StructurizrClientException(apiResponse.getMessage());
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new StructurizrClientException(e);
            }
        }
    }

    private void debugRequest(HttpUriRequestBase httpRequest, String content) {
        if (log.isDebugEnabled()) {
            Header[] headers;
            log.debug((Object)(httpRequest.getMethod() + " " + httpRequest.getPath()));
            for (Header header : headers = httpRequest.getHeaders()) {
                log.debug((Object)(header.getName() + ": " + header.getValue()));
            }
            if (content != null) {
                log.debug((Object)content);
            }
        }
    }

    private void debugResponse(CloseableHttpResponse response) {
        log.debug((Object)response.getCode());
    }

    private void addHeaders(HttpUriRequestBase httpRequest, String content, String contentType) throws Exception {
        String httpMethod = httpRequest.getMethod();
        String path = httpRequest.getPath();
        String contentMd5 = new Md5Digest().generate(content);
        String nonce = "" + System.currentTimeMillis();
        HashBasedMessageAuthenticationCode hmac = new HashBasedMessageAuthenticationCode(this.apiSecret);
        HmacContent hmacContent = new HmacContent(httpMethod, path, contentMd5, contentType, nonce);
        httpRequest.addHeader("User-Agent", (Object)STRUCTURIZR_FOR_JAVA_AGENT);
        httpRequest.addHeader("X-Authorization", (Object)new HmacAuthorizationHeader(this.apiKey, hmac.generate(hmacContent.toString())).format());
        httpRequest.addHeader("Nonce", (Object)nonce);
        if (httpMethod.equals("PUT")) {
            httpRequest.addHeader("Content-MD5", (Object)Base64.getEncoder().encodeToString(contentMd5.getBytes("UTF-8")));
            httpRequest.addHeader("Content-Type", (Object)contentType);
        }
    }

    private void archiveWorkspace(long workspaceId, String json) {
        if (this.workspaceArchiveLocation == null) {
            return;
        }
        File archiveFile = new File(this.workspaceArchiveLocation, this.createArchiveFileName(workspaceId));
        try (FileWriter fileWriter = new FileWriter(archiveFile);){
            fileWriter.write(json);
            fileWriter.flush();
            this.debugArchivedWorkspaceLocation(archiveFile);
        }
        catch (Exception e) {
            log.warn((Object)("Could not archive JSON to " + archiveFile.getAbsolutePath()));
        }
    }

    private void debugArchivedWorkspaceLocation(File archiveFile) {
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("Workspace from server archived to " + archiveFile.getCanonicalPath()));
            }
            catch (IOException ioe) {
                log.debug((Object)("Workspace from server archived to " + archiveFile.getAbsolutePath()));
            }
        }
    }

    private String createArchiveFileName(long workspaceId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return "structurizr-" + workspaceId + "-" + sdf.format(new Date()) + ".json";
    }

    private String getUser() {
        String username = System.getProperty("user.name");
        if (username.contains("@")) {
            return username;
        }
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return username + (!StringUtils.isNullOrEmpty((String)hostname) ? "@" + hostname : "");
    }
}

