/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.structurizr.encryption.EncryptedWorkspace;
import com.structurizr.io.WorkspaceWriterException;
import com.structurizr.io.json.AbstractJsonWriter;
import java.io.Writer;

public final class EncryptedJsonWriter
extends AbstractJsonWriter {
    private boolean indentOutput = true;

    public EncryptedJsonWriter(boolean indentOutput) {
        this.indentOutput = indentOutput;
    }

    public void write(EncryptedWorkspace workspace, Writer writer) throws WorkspaceWriterException {
        if (workspace == null) {
            throw new IllegalArgumentException("EncryptedWorkspace cannot be null.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("Writer cannot be null.");
        }
        try {
            ObjectMapper objectMapper = this.createObjectMapper(this.indentOutput);
            writer.write(objectMapper.writeValueAsString((Object)workspace));
        }
        catch (Exception e) {
            throw new WorkspaceWriterException("Could not write as JSON", e);
        }
    }
}

