/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.structurizr.Workspace;
import com.structurizr.io.WorkspaceWriter;
import com.structurizr.io.WorkspaceWriterException;
import com.structurizr.io.json.AbstractJsonWriter;
import java.io.IOException;
import java.io.Writer;

public final class JsonWriter
extends AbstractJsonWriter
implements WorkspaceWriter {
    private boolean indentOutput = true;

    public JsonWriter(boolean indentOutput) {
        this.indentOutput = indentOutput;
    }

    @Override
    public void write(Workspace workspace, Writer writer) throws WorkspaceWriterException {
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace cannot be null.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("Writer cannot be null.");
        }
        try {
            ObjectMapper objectMapper = this.createObjectMapper(this.indentOutput);
            writer.write(objectMapper.writeValueAsString((Object)workspace));
        }
        catch (IOException ioe) {
            throw new WorkspaceWriterException("Could not write as JSON", ioe);
        }
    }
}

