/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.util;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.structurizr.Workspace;
import com.structurizr.io.WorkspaceWriterException;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.RelationshipStyle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public final class ThemeUtils {
    private static final int HTTP_OK_STATUS = 200;

    public static void toJson(Workspace workspace, File file) throws Exception {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        if (file == null) {
            throw new IllegalArgumentException("The path to a file must be specified.");
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        ThemeUtils.write(workspace, writer);
    }

    public static String toJson(Workspace workspace) throws Exception {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        StringWriter writer = new StringWriter();
        ThemeUtils.write(workspace, writer);
        return writer.toString();
    }

    public static void loadStylesFromThemes(Workspace workspace) throws Exception {
        if (workspace.getViews().getConfiguration().getThemes() != null) {
            for (String url : workspace.getViews().getConfiguration().getThemes()) {
                HttpGet httpGet;
                CloseableHttpClient httpClient = HttpClients.createSystem();
                CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)(httpGet = new HttpGet(url)));
                if (response.getCode() == 200) {
                    String json = EntityUtils.toString((HttpEntity)response.getEntity());
                    ObjectMapper objectMapper = new ObjectMapper();
                    objectMapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
                    objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    Theme theme = (Theme)objectMapper.readValue(json, Theme.class);
                    for (ElementStyle elementStyle : theme.getElements()) {
                        workspace.getViews().getConfiguration().getStyles().add(elementStyle);
                    }
                    for (RelationshipStyle relationshipStyle : theme.getRelationships()) {
                        workspace.getViews().getConfiguration().getStyles().add(relationshipStyle);
                    }
                }
                httpClient.close();
            }
        }
    }

    private static void write(Workspace workspace, Writer writer) throws Exception {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            writer.write(objectMapper.writeValueAsString((Object)new Theme(workspace.getName(), workspace.getDescription(), workspace.getViews().getConfiguration().getStyles().getElements(), workspace.getViews().getConfiguration().getStyles().getRelationships())));
        }
        catch (IOException ioe) {
            throw new WorkspaceWriterException("Could not write the theme as JSON", ioe);
        }
        writer.flush();
        writer.close();
    }

    static class Theme {
        private String name;
        private String description;
        private Collection<ElementStyle> elements = new LinkedList<ElementStyle>();
        private Collection<RelationshipStyle> relationships = new LinkedList<RelationshipStyle>();

        Theme() {
        }

        Theme(String name, String description, Collection<ElementStyle> elements, Collection<RelationshipStyle> relationships) {
            this.name = name;
            this.description = description;
            this.elements = elements;
            this.relationships = relationships;
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        void setDescription(String description) {
            this.description = description;
        }

        @JsonGetter
        Collection<ElementStyle> getElements() {
            return this.elements;
        }

        void setElements(Collection<ElementStyle> elements) {
            this.elements = elements;
        }

        @JsonGetter
        Collection<RelationshipStyle> getRelationships() {
            return this.relationships;
        }

        void setRelationships(Collection<RelationshipStyle> relationships) {
            this.relationships = relationships;
        }
    }
}

