/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.api;

import com.structurizr.Workspace;
import com.structurizr.api.AbstractApiClient;
import com.structurizr.api.ApiResponse;
import com.structurizr.api.HashBasedMessageAuthenticationCode;
import com.structurizr.api.HmacAuthorizationHeader;
import com.structurizr.api.HmacContent;
import com.structurizr.api.Md5Digest;
import com.structurizr.api.StructurizrClientException;
import com.structurizr.encryption.EncryptedWorkspace;
import com.structurizr.encryption.EncryptionLocation;
import com.structurizr.encryption.EncryptionStrategy;
import com.structurizr.io.json.EncryptedJsonReader;
import com.structurizr.io.json.EncryptedJsonWriter;
import com.structurizr.io.json.JsonReader;
import com.structurizr.io.json.JsonWriter;
import com.structurizr.model.IdGenerator;
import com.structurizr.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class WorkspaceApiClient
extends AbstractApiClient {
    private static final Log log = LogFactory.getLog(WorkspaceApiClient.class);
    private String user;
    private String apiKey;
    private String apiSecret;
    private String branch = "";
    private EncryptionStrategy encryptionStrategy;
    private IdGenerator idGenerator = null;
    private boolean mergeFromRemote = true;
    private File workspaceArchiveLocation = new File(".");

    protected WorkspaceApiClient() {
    }

    public WorkspaceApiClient(String apiKey, String apiSecret) {
        this("https://api.structurizr.com", apiKey, apiSecret);
    }

    public WorkspaceApiClient(String url, String apiKey, String apiSecret) {
        this.setUrl(url);
        this.setApiKey(apiKey);
        this.setApiSecret(apiSecret);
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    String getApiKey() {
        return this.apiKey;
    }

    protected void setApiKey(String apiKey) {
        if (apiKey == null || apiKey.trim().length() == 0) {
            throw new IllegalArgumentException("The API key must not be null or empty.");
        }
        this.apiKey = apiKey;
    }

    String getApiSecret() {
        return this.apiSecret;
    }

    protected void setApiSecret(String apiSecret) {
        if (apiSecret == null || apiSecret.trim().length() == 0) {
            throw new IllegalArgumentException("The API secret must not be null or empty.");
        }
        this.apiSecret = apiSecret;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public File getWorkspaceArchiveLocation() {
        return this.workspaceArchiveLocation;
    }

    public void setWorkspaceArchiveLocation(File workspaceArchiveLocation) {
        this.workspaceArchiveLocation = workspaceArchiveLocation;
    }

    public void setEncryptionStrategy(EncryptionStrategy encryptionStrategy) {
        this.encryptionStrategy = encryptionStrategy;
    }

    public void setMergeFromRemote(boolean mergeFromRemote) {
        this.mergeFromRemote = mergeFromRemote;
    }

    public boolean lockWorkspace(long workspaceId) throws StructurizrClientException {
        return this.manageLockForWorkspace(workspaceId, true);
    }

    public boolean unlockWorkspace(long workspaceId) throws StructurizrClientException {
        return this.manageLockForWorkspace(workspaceId, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean manageLockForWorkspace(long workspaceId, boolean lock) throws StructurizrClientException {
        if (workspaceId <= 0L) {
            throw new IllegalArgumentException("The workspace ID must be a positive integer.");
        }
        try (CloseableHttpClient httpClient = HttpClients.createSystem();){
            HttpPut httpRequest;
            if (lock) {
                log.info((Object)("Locking workspace with ID " + workspaceId));
                httpRequest = new HttpPut(this.url + "/workspace/" + workspaceId + "/lock?user=" + this.getUser() + "&agent=" + this.agent);
            } else {
                log.info((Object)("Unlocking workspace with ID " + workspaceId));
                httpRequest = new HttpDelete(this.url + "/workspace/" + workspaceId + "/lock?user=" + this.getUser() + "&agent=" + this.agent);
            }
            this.addHeaders((HttpUriRequestBase)httpRequest, "", "");
            this.debugRequest((HttpUriRequestBase)httpRequest, null);
            try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpRequest);){
                this.debugResponse(response);
                String responseText = EntityUtils.toString((HttpEntity)response.getEntity());
                ApiResponse apiResponse = ApiResponse.parse(responseText);
                log.info((Object)responseText);
                if (response.getCode() != 200) throw new StructurizrClientException(apiResponse.getMessage());
                boolean bl = apiResponse.isSuccess();
                return bl;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new StructurizrClientException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Workspace getWorkspace(long workspaceId) throws StructurizrClientException {
        if (workspaceId <= 0L) {
            throw new IllegalArgumentException("The workspace ID must be a positive integer.");
        }
        try (CloseableHttpClient httpClient = HttpClients.createSystem();){
            log.info((Object)("Getting workspace with ID " + workspaceId));
            HttpGet httpGet = StringUtils.isNullOrEmpty((String)this.branch) ? new HttpGet(this.url + "/workspace/" + workspaceId) : new HttpGet(this.url + "/workspace/" + workspaceId + "/branch/" + this.branch);
            this.addHeaders((HttpUriRequestBase)httpGet, "", "");
            this.debugRequest((HttpUriRequestBase)httpGet, null);
            try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpGet);){
                this.debugResponse(response);
                String json = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getCode() == 200) {
                    this.archiveWorkspace(workspaceId, json);
                    if (this.encryptionStrategy == null) {
                        if (json.contains("\"encryptionStrategy\"") && json.contains("\"ciphertext\"")) {
                            log.warn((Object)"The JSON may contain a client-side encrypted workspace, but no passphrase has been specified.");
                        }
                        JsonReader jsonReader = new JsonReader();
                        jsonReader.setIdGenerator(this.idGenerator);
                        Workspace workspace = jsonReader.read(new StringReader(json));
                        return workspace;
                    }
                    EncryptedWorkspace encryptedWorkspace = new EncryptedJsonReader().read(new StringReader(json));
                    if (encryptedWorkspace.getEncryptionStrategy() != null) {
                        encryptedWorkspace.getEncryptionStrategy().setPassphrase(this.encryptionStrategy.getPassphrase());
                        Workspace workspace = encryptedWorkspace.getWorkspace();
                        return workspace;
                    }
                    JsonReader jsonReader = new JsonReader();
                    jsonReader.setIdGenerator(this.idGenerator);
                    Workspace workspace = jsonReader.read(new StringReader(json));
                    return workspace;
                }
                ApiResponse apiResponse = ApiResponse.parse(json);
                throw new StructurizrClientException(apiResponse.getMessage());
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new StructurizrClientException(e);
        }
    }

    public void putWorkspace(long workspaceId, Workspace workspace) throws StructurizrClientException {
        block20: {
            if (workspace == null) {
                throw new IllegalArgumentException("The workspace must not be null.");
            }
            if (workspaceId <= 0L) {
                throw new IllegalArgumentException("The workspace ID must be a positive integer.");
            }
            try (CloseableHttpClient httpClient = HttpClients.createSystem();){
                Workspace remoteWorkspace;
                if (this.mergeFromRemote && (remoteWorkspace = this.getWorkspace(workspaceId)) != null) {
                    workspace.getViews().copyLayoutInformationFrom(remoteWorkspace.getViews());
                    workspace.getViews().getConfiguration().copyConfigurationFrom(remoteWorkspace.getViews().getConfiguration());
                }
                workspace.setId(workspaceId);
                workspace.setThumbnail(null);
                workspace.setLastModifiedDate(new Date());
                workspace.setLastModifiedAgent(this.agent);
                workspace.setLastModifiedUser(this.getUser());
                HttpPut httpPut = StringUtils.isNullOrEmpty((String)this.branch) ? new HttpPut(this.url + "/workspace/" + workspaceId) : new HttpPut(this.url + "/workspace/" + workspaceId + "/branch/" + this.branch);
                StringWriter stringWriter = new StringWriter();
                if (this.encryptionStrategy == null) {
                    JsonWriter jsonWriter = new JsonWriter(false);
                    jsonWriter.write(workspace, stringWriter);
                } else {
                    EncryptedWorkspace encryptedWorkspace = new EncryptedWorkspace(workspace, this.encryptionStrategy);
                    this.encryptionStrategy.setLocation(EncryptionLocation.Client);
                    EncryptedJsonWriter jsonWriter = new EncryptedJsonWriter(false);
                    jsonWriter.write(encryptedWorkspace, stringWriter);
                }
                StringEntity stringEntity = new StringEntity(stringWriter.toString(), ContentType.APPLICATION_JSON);
                httpPut.setEntity((HttpEntity)stringEntity);
                this.addHeaders((HttpUriRequestBase)httpPut, EntityUtils.toString((HttpEntity)stringEntity), ContentType.APPLICATION_JSON.toString());
                this.debugRequest((HttpUriRequestBase)httpPut, EntityUtils.toString((HttpEntity)stringEntity));
                log.info((Object)("Putting workspace with ID " + workspaceId));
                try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpPut);){
                    String json = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (response.getCode() == 200) {
                        this.debugResponse(response);
                        log.info((Object)json);
                        break block20;
                    }
                    ApiResponse apiResponse = ApiResponse.parse(json);
                    throw new StructurizrClientException(apiResponse.getMessage());
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new StructurizrClientException(e);
            }
        }
    }

    private void debugRequest(HttpUriRequestBase httpRequest, String content) {
        if (log.isDebugEnabled()) {
            Header[] headers;
            log.debug((Object)(httpRequest.getMethod() + " " + httpRequest.getPath()));
            for (Header header : headers = httpRequest.getHeaders()) {
                log.debug((Object)(header.getName() + ": " + header.getValue()));
            }
            if (content != null) {
                log.debug((Object)content);
            }
        }
    }

    private void debugResponse(CloseableHttpResponse response) {
        log.debug((Object)response.getCode());
    }

    private void addHeaders(HttpUriRequestBase httpRequest, String content, String contentType) throws Exception {
        String httpMethod = httpRequest.getMethod();
        String path = httpRequest.getPath();
        String contentMd5 = new Md5Digest().generate(content);
        String nonce = "" + System.currentTimeMillis();
        HashBasedMessageAuthenticationCode hmac = new HashBasedMessageAuthenticationCode(this.apiSecret);
        HmacContent hmacContent = new HmacContent(httpMethod, path, contentMd5, contentType, nonce);
        httpRequest.addHeader("User-Agent", (Object)this.agent);
        httpRequest.addHeader("X-Authorization", (Object)new HmacAuthorizationHeader(this.apiKey, hmac.generate(hmacContent.toString())).format());
        httpRequest.addHeader("Nonce", (Object)nonce);
        if (httpMethod.equals("PUT")) {
            httpRequest.addHeader("Content-MD5", (Object)Base64.getEncoder().encodeToString(contentMd5.getBytes(StandardCharsets.UTF_8)));
            httpRequest.addHeader("Content-Type", (Object)contentType);
        }
    }

    private void archiveWorkspace(long workspaceId, String json) {
        if (this.workspaceArchiveLocation == null) {
            return;
        }
        File archiveFile = new File(this.workspaceArchiveLocation, this.createArchiveFileName(workspaceId));
        try (FileWriter fileWriter = new FileWriter(archiveFile);){
            fileWriter.write(json);
            fileWriter.flush();
            this.debugArchivedWorkspaceLocation(archiveFile);
        }
        catch (Exception e) {
            log.warn((Object)("Could not archive JSON to " + archiveFile.getAbsolutePath()));
        }
    }

    private void debugArchivedWorkspaceLocation(File archiveFile) {
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("Workspace from server archived to " + archiveFile.getCanonicalPath()));
            }
            catch (IOException ioe) {
                log.debug((Object)("Workspace from server archived to " + archiveFile.getAbsolutePath()));
            }
        }
    }

    private String createArchiveFileName(long workspaceId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        return "structurizr-" + workspaceId + "-" + sdf.format(new Date()) + ".json";
    }

    public void setUser(String user) {
        this.user = user;
    }

    private String getUser() {
        if (!StringUtils.isNullOrEmpty((String)this.user)) {
            return this.user;
        }
        String username = System.getProperty("user.name");
        if (username.contains("@")) {
            return username;
        }
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return username + (String)(!StringUtils.isNullOrEmpty((String)hostname) ? "@" + hostname : "");
    }
}

