/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

class AbstractJsonWriter {
    private static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    AbstractJsonWriter() {
    }

    ObjectMapper createObjectMapper(boolean indentOutput) {
        ObjectMapper objectMapper = ((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).build();
        if (indentOutput) {
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SimpleDateFormat sdf = new SimpleDateFormat(ISO_DATE_TIME_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        objectMapper.setDateFormat((DateFormat)sdf);
        return objectMapper;
    }
}

