/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.structurizr.api.AbstractApiClient;
import com.structurizr.api.ApiResponse;
import com.structurizr.api.StructurizrClientException;
import com.structurizr.api.WorkspaceMetadata;
import com.structurizr.api.Workspaces;
import com.structurizr.util.StringUtils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdminApiClient
extends AbstractApiClient {
    private static final Log log = LogFactory.getLog(AdminApiClient.class);
    private final String username;
    private final String apiKey;

    public AdminApiClient(String url, String username, String apiKey) {
        this.setUrl(url);
        this.username = username;
        if (apiKey == null || apiKey.trim().length() == 0) {
            throw new IllegalArgumentException("The API key must not be null or empty.");
        }
        this.apiKey = apiKey;
    }

    public List<WorkspaceMetadata> getWorkspaces() throws StructurizrClientException {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.url + "/workspace")).header("X-Authorization", this.createAuthorizationHeader()).header("User-Agent", this.agent).build();
            HttpClient client = HttpClient.newHttpClient();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String json = response.body();
            if (response.statusCode() == 200) {
                Workspaces workspaces = (Workspaces)objectMapper.readValue(response.body(), Workspaces.class);
                return workspaces.getWorkspaces();
            }
            ApiResponse apiResponse = ApiResponse.parse(json);
            throw new StructurizrClientException(apiResponse.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new StructurizrClientException(e);
        }
    }

    public WorkspaceMetadata createWorkspace() throws StructurizrClientException {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.url + "/workspace")).POST(HttpRequest.BodyPublishers.noBody()).header("X-Authorization", this.createAuthorizationHeader()).header("User-Agent", this.agent).build();
            HttpClient client = HttpClient.newHttpClient();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String json = response.body();
            if (response.statusCode() == 200) {
                return (WorkspaceMetadata)objectMapper.readValue(json, WorkspaceMetadata.class);
            }
            ApiResponse apiResponse = ApiResponse.parse(json);
            throw new StructurizrClientException(apiResponse.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new StructurizrClientException(e);
        }
    }

    public void deleteWorkspace(int workspaceId) throws StructurizrClientException {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.url + "/workspace/" + workspaceId)).DELETE().header("X-Authorization", this.createAuthorizationHeader()).header("User-Agent", this.agent).build();
            HttpClient client = HttpClient.newHttpClient();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String json = response.body();
            if (response.statusCode() != 200) {
                ApiResponse apiResponse = ApiResponse.parse(json);
                throw new StructurizrClientException(apiResponse.getMessage());
            }
            ApiResponse apiResponse = ApiResponse.parse(json);
            log.debug((Object)apiResponse.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new StructurizrClientException(e);
        }
    }

    private String createAuthorizationHeader() {
        if (StringUtils.isNullOrEmpty((String)this.username)) {
            return this.apiKey;
        }
        return this.username + ":" + this.apiKey;
    }
}

