/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component;

import com.structurizr.component.Type;
import com.structurizr.component.TypeRepository;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TypeDependencyFinder {
    private static final Log log = LogFactory.getLog(TypeDependencyFinder.class);

    TypeDependencyFinder() {
    }

    void run(Type type, TypeRepository typeRepository) {
        log.debug((Object)("Type dependencies for " + type.getFullyQualifiedName() + ":"));
        ConstantPool cp = type.getJavaClass().getConstantPool();
        ConstantPoolGen cpg = new ConstantPoolGen(cp);
        for (Method m : type.getJavaClass().getMethods()) {
            InstructionHandle[] instructionHandles;
            MethodGen mg = new MethodGen(m, type.getJavaClass().getClassName(), cpg);
            InstructionList il = mg.getInstructionList();
            if (il == null) continue;
            for (InstructionHandle instructionHandle : instructionHandles = il.getInstructionHandles()) {
                ObjectType objectType;
                String referencedClassName;
                Type referencedType;
                InvokeInstruction invokeInstruction;
                ReferenceType referenceType;
                Instruction instruction = instructionHandle.getInstruction();
                if (!(instruction instanceof InvokeInstruction) || !((referenceType = (invokeInstruction = (InvokeInstruction)instruction).getReferenceType(cpg)) instanceof ObjectType) || (referencedType = typeRepository.getType(referencedClassName = (objectType = (ObjectType)referenceType).getClassName())) == null || referencedType.getFullyQualifiedName().equals(type.getFullyQualifiedName()) || type.hasDependency(referencedType)) continue;
                log.debug((Object)(" + " + referencedType.getFullyQualifiedName()));
                type.addDependency(referencedType);
            }
        }
        if (type.getDependencies().isEmpty()) {
            log.debug((Object)" - none");
        }
    }
}

