/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component;

import com.structurizr.component.Type;
import com.structurizr.component.TypeRepository;
import com.structurizr.component.filter.TypeFilter;
import com.structurizr.component.provider.TypeProvider;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TypeFinder {
    private static final Log log = LogFactory.getLog(TypeFinder.class);

    TypeFinder() {
    }

    void run(Collection<TypeProvider> typeProviders, TypeFilter typeFilter, TypeRepository typeRepository) {
        for (TypeProvider typeProvider : typeProviders) {
            log.debug((Object)("Running " + typeProvider.toString()));
            Set<Type> types = typeProvider.getTypes();
            for (Type type : types) {
                boolean accepted = typeFilter.accept(type);
                if (accepted) {
                    log.debug((Object)(" + " + type.getFullyQualifiedName() + " (accepted=true)"));
                } else {
                    log.debug((Object)(" - " + type.getFullyQualifiedName() + " (accepted=false)"));
                }
                if (!accepted) continue;
                typeRepository.add(type);
            }
        }
    }
}

