/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.matcher;

import com.structurizr.component.Type;
import com.structurizr.component.matcher.TypeMatcher;
import com.structurizr.util.StringUtils;
import java.lang.annotation.Annotation;
import org.apache.bcel.classfile.AnnotationEntry;

public class AnnotationTypeMatcher
implements TypeMatcher {
    private final String annotationType;

    public AnnotationTypeMatcher(String annotationType) {
        if (StringUtils.isNullOrEmpty((String)annotationType)) {
            throw new IllegalArgumentException("An annotation type must be supplied");
        }
        this.annotationType = "L" + annotationType.replace(".", "/") + ";";
    }

    public AnnotationTypeMatcher(Class<? extends Annotation> annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("An annotation must be supplied");
        }
        this.annotationType = "L" + annotation.getCanonicalName().replace(".", "/") + ";";
    }

    @Override
    public boolean matches(Type type) {
        AnnotationEntry[] annotationEntries;
        if (type == null) {
            throw new IllegalArgumentException("A type must be specified");
        }
        if (type.getJavaClass() == null) {
            return false;
        }
        for (AnnotationEntry annotationEntry : annotationEntries = type.getJavaClass().getAnnotationEntries()) {
            if (!this.annotationType.equals(annotationEntry.getAnnotationType())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "AnnotationTypeMatcher{annotationType='" + this.annotationType + "'}";
    }
}

