/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.matcher;

import com.structurizr.component.Type;
import com.structurizr.component.matcher.TypeMatcher;
import com.structurizr.util.StringUtils;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImplementsTypeMatcher
implements TypeMatcher {
    private static final Log log = LogFactory.getLog(ImplementsTypeMatcher.class);
    private final String interfaceName;

    public ImplementsTypeMatcher(String interfaceName) {
        if (StringUtils.isNullOrEmpty((String)interfaceName)) {
            throw new IllegalArgumentException("A fully qualified interface name must be supplied");
        }
        this.interfaceName = interfaceName;
    }

    @Override
    public boolean matches(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("A type must be specified");
        }
        if (type.getJavaClass() == null) {
            return false;
        }
        JavaClass javaClass = type.getJavaClass();
        Set<String> interfaceNames = Set.of(javaClass.getInterfaceNames());
        return interfaceNames.contains(this.interfaceName);
    }

    public String toString() {
        return "ImplementsTypeMatcher{interfaceName='" + this.interfaceName + "'}";
    }
}

