/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.provider;

import com.structurizr.component.Type;
import com.structurizr.component.provider.TypeProvider;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClassJarFileTypeProvider
implements TypeProvider {
    private static final Log log = LogFactory.getLog(ClassJarFileTypeProvider.class);
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final File jarFile;

    public ClassJarFileTypeProvider(File file) {
        this.jarFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Type> getTypes() {
        LinkedHashSet<Type> types = new LinkedHashSet<Type>();
        JarFile jar = null;
        try {
            jar = new JarFile(this.jarFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(CLASS_FILE_EXTENSION)) continue;
                ClassParser parser = new ClassParser(this.jarFile.getAbsolutePath(), entry.getName());
                JavaClass javaClass = parser.parse();
                types.add(new Type(javaClass));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return types;
    }

    public String toString() {
        return "ClassJarFileTypeProvider{jarFile=" + this.jarFile + "}";
    }
}

