/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.provider;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.structurizr.component.Type;
import com.structurizr.component.provider.JavadocCommentFilter;
import com.structurizr.component.provider.TypeProvider;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SourceDirectoryTypeProvider
implements TypeProvider {
    private static final Log log = LogFactory.getLog(SourceDirectoryTypeProvider.class);
    private static final String JAVA_FILE_EXTENSION = ".java";
    private final File directory;
    private final Set<Type> types = new LinkedHashSet<Type>();

    public SourceDirectoryTypeProvider(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("A directory must be supplied");
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory.getAbsolutePath() + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory");
        }
        this.directory = directory;
        StaticJavaParser.getParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_21);
    }

    @Override
    public Set<Type> getTypes() {
        this.parse(this.directory);
        return new LinkedHashSet<Type>(this.types);
    }

    private void parse(final File path) {
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (File file : files) {
                    try {
                        this.parse(file);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Error parsing " + file.getAbsolutePath()), (Throwable)e);
                    }
                }
            }
        } else if (path.getName().endsWith(JAVA_FILE_EXTENSION)) {
            try {
                new VoidVisitorAdapter<Object>(){

                    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
                        if (n.getFullyQualifiedName().isPresent()) {
                            String fullyQualifiedName = (String)n.getFullyQualifiedName().get();
                            Type type = new Type(fullyQualifiedName);
                            type.setSource(SourceDirectoryTypeProvider.this.relativePath(path));
                            if (n.getComment().isPresent() && n.getComment().get() instanceof JavadocComment) {
                                JavadocComment javadocComment = (JavadocComment)n.getComment().get();
                                String description = javadocComment.parse().getDescription().toText();
                                type.setDescription(new JavadocCommentFilter().filter(description));
                            }
                            SourceDirectoryTypeProvider.this.types.add(type);
                        }
                    }

                    public void visit(PackageDeclaration n, Object arg) {
                        String PACKAGE_INFO_JAVA_SOURCE = "package-info.java";
                        String PACKAGE_INFO_SUFFIX = ".package-info";
                        if (path.getName().endsWith(PACKAGE_INFO_JAVA_SOURCE)) {
                            String fullyQualifiedName = n.getName().asString() + PACKAGE_INFO_SUFFIX;
                            Type type = new Type(fullyQualifiedName);
                            type.setSource(SourceDirectoryTypeProvider.this.relativePath(path));
                            Node rootNode = n.findRootNode();
                            if (rootNode != null && rootNode.getComment().isPresent() && rootNode.getComment().get() instanceof JavadocComment) {
                                JavadocComment javadocComment = (JavadocComment)rootNode.getComment().get();
                                String description = javadocComment.parse().getDescription().toText();
                                type.setDescription(new JavadocCommentFilter().filter(description));
                            }
                            SourceDirectoryTypeProvider.this.types.add(type);
                        }
                    }
                }.visit(StaticJavaParser.parse((File)path), null);
            }
            catch (IOException e) {
                log.warn((Object)"Error parsing source code", (Throwable)e);
            }
        } else {
            log.debug((Object)("Ignoring " + path.getAbsolutePath()));
        }
    }

    private String relativePath(File path) {
        String pathSeparator;
        String relativePath = path.getAbsolutePath().replace(this.directory.getAbsolutePath(), "");
        if (relativePath.startsWith(pathSeparator = System.getProperty("file.separator"))) {
            relativePath = relativePath.substring(1);
        }
        return relativePath;
    }

    public String toString() {
        return "SourceDirectoryTypeProvider{directory=" + this.directory + "}";
    }
}

