/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.url;

import com.structurizr.component.Type;
import com.structurizr.component.url.UrlStrategy;
import com.structurizr.util.StringUtils;

public class PrefixSourceUrlStrategy
implements UrlStrategy {
    private final String prefix;

    public PrefixSourceUrlStrategy(String prefix) {
        if (StringUtils.isNullOrEmpty((String)prefix)) {
            throw new IllegalArgumentException("A prefix must be supplied");
        }
        if (!((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        this.prefix = prefix;
    }

    @Override
    public String urlOf(Type type) {
        if (type.getSource() != null) {
            return this.prefix + type.getSource().replaceAll("\\\\", "/");
        }
        return null;
    }

    public String toString() {
        return "PrefixUrlStrategy{prefix='" + this.prefix + "'}";
    }
}

