/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component;

import com.structurizr.component.ComponentFinderStrategy;
import com.structurizr.component.DiscoveredComponent;
import com.structurizr.component.Type;
import com.structurizr.component.TypeDependencyFinder;
import com.structurizr.component.TypeFinder;
import com.structurizr.component.TypeRepository;
import com.structurizr.component.filter.TypeFilter;
import com.structurizr.component.provider.TypeProvider;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ComponentFinder {
    private static final Log log = LogFactory.getLog(ComponentFinder.class);
    private static final String COMPONENT_TYPE_PROPERTY_NAME = "component.type";
    private static final String COMPONENT_SOURCE_PROPERTY_NAME = "component.src";
    private final TypeRepository typeRepository = new TypeRepository();
    private final Container container;
    private final List<ComponentFinderStrategy> componentFinderStrategies = new ArrayList<ComponentFinderStrategy>();

    ComponentFinder(Container container, TypeFilter typeFilter, Collection<TypeProvider> typeProviders, List<ComponentFinderStrategy> componentFinderStrategies) {
        this.container = container;
        this.componentFinderStrategies.addAll(componentFinderStrategies);
        log.debug((Object)"Initialising component finder:");
        log.debug((Object)(" - for: " + container.getCanonicalName()));
        for (TypeProvider typeProvider : typeProviders) {
            log.debug((Object)(" - from: " + typeProvider));
        }
        log.debug((Object)(" - filtered by: " + typeFilter));
        for (ComponentFinderStrategy strategy : componentFinderStrategies) {
            log.debug((Object)(" - with strategy: " + strategy));
        }
        new TypeFinder().run(typeProviders, typeFilter, this.typeRepository);
        Repository.clearCache();
        for (Type type : this.typeRepository.getTypes()) {
            if (type.getJavaClass() == null) continue;
            Repository.addClass((JavaClass)type.getJavaClass());
            new TypeDependencyFinder().run(type, this.typeRepository);
        }
    }

    public Set<Component> run() {
        Component component;
        LinkedHashSet<DiscoveredComponent> discoveredComponents = new LinkedHashSet<DiscoveredComponent>();
        HashMap<DiscoveredComponent, Component> componentMap = new HashMap<DiscoveredComponent, Component>();
        LinkedHashSet<Component> componentSet = new LinkedHashSet<Component>();
        for (ComponentFinderStrategy componentFinderStrategy : this.componentFinderStrategies) {
            Set<DiscoveredComponent> set = componentFinderStrategy.run(this.typeRepository);
            if (set.isEmpty()) {
                throw new RuntimeException("No components were found by " + componentFinderStrategy);
            }
            discoveredComponents.addAll(set);
        }
        for (DiscoveredComponent discoveredComponent : discoveredComponents) {
            component = this.container.addComponent(discoveredComponent.getName());
            component.addProperty(COMPONENT_TYPE_PROPERTY_NAME, discoveredComponent.getPrimaryType().getFullyQualifiedName());
            if (!StringUtils.isNullOrEmpty((String)discoveredComponent.getPrimaryType().getSource())) {
                component.addProperty(COMPONENT_SOURCE_PROPERTY_NAME, discoveredComponent.getPrimaryType().getSource());
            }
            component.setDescription(discoveredComponent.getDescription());
            component.setTechnology(discoveredComponent.getTechnology());
            component.setUrl(discoveredComponent.getUrl());
            component.addTags(discoveredComponent.getTags().toArray(new String[0]));
            for (String name : discoveredComponent.getProperties().keySet()) {
                component.addProperty(name, discoveredComponent.getProperties().get(name));
            }
            componentMap.put(discoveredComponent, component);
            componentSet.add(component);
        }
        for (DiscoveredComponent discoveredComponent : discoveredComponents) {
            component = (Component)componentMap.get(discoveredComponent);
            log.debug((Object)("Component dependencies for \"" + component.getName() + "\":"));
            Set<Type> typeDependencies = discoveredComponent.getAllDependencies();
            for (Type typeDependency : typeDependencies) {
                for (DiscoveredComponent c : discoveredComponents) {
                    if (c == discoveredComponent || !c.getAllTypes().contains(typeDependency)) continue;
                    Component componentDependency = (Component)componentMap.get(c);
                    log.debug((Object)(" -> " + componentDependency.getName()));
                    component.uses(componentDependency, "");
                }
            }
            if (!component.getRelationships().isEmpty()) continue;
            log.debug((Object)" - none");
        }
        for (DiscoveredComponent discoveredComponent : componentMap.keySet()) {
            component = (Component)componentMap.get(discoveredComponent);
            log.debug((Object)("Visiting \"" + component.getName() + "\""));
            discoveredComponent.getComponentFinderStrategy().visit(component);
        }
        return componentSet;
    }
}

