/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component;

import com.structurizr.component.ComponentFinderStrategy;
import com.structurizr.component.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class DiscoveredComponent {
    private final Type primaryType;
    private final String name;
    private String description;
    private String technology;
    private String url;
    private final List<String> tags = new ArrayList<String>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Set<Type> supportingTypes = new HashSet<Type>();
    private ComponentFinderStrategy componentFinderStrategy;

    DiscoveredComponent(String name, Type primaryType) {
        this.name = name;
        this.primaryType = primaryType;
    }

    void addSupportingTypes(Set<Type> types) {
        this.supportingTypes.addAll(types);
    }

    Type getPrimaryType() {
        return this.primaryType;
    }

    String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    String getTechnology() {
        return this.technology;
    }

    void setTechnology(String technology) {
        this.technology = technology;
    }

    String getUrl() {
        return this.url;
    }

    void setUrl(String url) {
        this.url = url;
    }

    void addTags(List<String> tags) {
        this.tags.addAll(tags);
    }

    List<String> getTags() {
        return List.copyOf(this.tags);
    }

    void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    Map<String, String> getProperties() {
        return Map.copyOf(this.properties);
    }

    Set<Type> getSupportingTypes() {
        return new HashSet<Type>(this.supportingTypes);
    }

    Set<Type> getAllTypes() {
        HashSet<Type> types = new HashSet<Type>();
        types.add(this.primaryType);
        types.addAll(this.supportingTypes);
        return types;
    }

    Set<Type> getAllDependencies() {
        HashSet<Type> dependencies = new HashSet<Type>();
        for (Type type : this.getAllTypes()) {
            dependencies.addAll(type.getDependencies());
        }
        return dependencies;
    }

    ComponentFinderStrategy getComponentFinderStrategy() {
        return this.componentFinderStrategy;
    }

    void setComponentFinderStrategy(ComponentFinderStrategy componentFinderStrategy) {
        this.componentFinderStrategy = componentFinderStrategy;
    }

    public String toString() {
        return "DiscoveredComponent{name='" + this.name + "'}";
    }
}

