/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component;

import com.structurizr.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.bcel.classfile.AnnotationElementValue;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Type {
    private static final Log log = LogFactory.getLog(Type.class);
    private static final String STRUCTURIZR_TAG_ANNOTATION = "Lcom/structurizr/annotation/Tag;";
    private static final String STRUCTURIZR_TAGS_ANNOTATION = "Lcom/structurizr/annotation/Tags;";
    private static final String STRUCTURIZR_PROPERTY_ANNOTATION = "Lcom/structurizr/annotation/Property;";
    private static final String STRUCTURIZR_PROPERTIES_ANNOTATION = "Lcom/structurizr/annotation/Properties;";
    private JavaClass javaClass = null;
    private final String fullyQualifiedName;
    private String description;
    private String source;
    private final Set<Type> dependencies = new LinkedHashSet<Type>();

    public Type(JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException("A BCEL JavaClass must be supplied");
        }
        this.fullyQualifiedName = javaClass.getClassName();
        this.javaClass = javaClass;
    }

    public Type(String fullyQualifiedName) {
        if (StringUtils.isNullOrEmpty((String)fullyQualifiedName)) {
            throw new IllegalArgumentException("A fully qualified name must be supplied");
        }
        this.fullyQualifiedName = fullyQualifiedName;
        this.javaClass = null;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public String getName() {
        return this.fullyQualifiedName.substring(this.fullyQualifiedName.lastIndexOf(".") + 1);
    }

    public String getPackageName() {
        return this.getFullyQualifiedName().substring(0, this.getFullyQualifiedName().lastIndexOf("."));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public JavaClass getJavaClass() {
        return this.javaClass;
    }

    void setJavaClass(JavaClass javaClass) {
        this.javaClass = javaClass;
    }

    public void addDependency(Type type) {
        this.dependencies.add(type);
    }

    public Set<Type> getDependencies() {
        return new LinkedHashSet<Type>(this.dependencies);
    }

    public boolean hasDependency(Type type) {
        return this.dependencies.contains(type);
    }

    public boolean isAbstractClass() {
        return this.javaClass.isAbstract() && this.javaClass.isClass();
    }

    public boolean isInterface() {
        return this.javaClass.isInterface();
    }

    public List<String> getTags() {
        AnnotationEntry[] annotationEntries;
        ArrayList<String> tags = new ArrayList<String>();
        for (AnnotationEntry annotationEntry : annotationEntries = this.javaClass.getAnnotationEntries()) {
            ElementValuePair elementValuePair;
            if (STRUCTURIZR_TAG_ANNOTATION.equals(annotationEntry.getAnnotationType())) {
                elementValuePair = annotationEntry.getElementValuePairs()[0];
                String tag = elementValuePair.getValue().stringifyValue();
                tags.add(tag);
                continue;
            }
            if (!STRUCTURIZR_TAGS_ANNOTATION.equals(annotationEntry.getAnnotationType())) continue;
            elementValuePair = annotationEntry.getElementValuePairs()[0];
            ArrayElementValue elementValue = (ArrayElementValue)elementValuePair.getValue();
            for (ElementValue value : elementValue.getElementValuesArray()) {
                AnnotationElementValue annotationElementValue = (AnnotationElementValue)value;
                AnnotationEntry tagAannotationEntry = annotationElementValue.getAnnotationEntry();
                String tag = tagAannotationEntry.getElementValuePairs()[0].getValue().stringifyValue();
                tags.add(tag);
            }
        }
        return tags;
    }

    public Map<String, String> getProperties() {
        AnnotationEntry[] annotationEntries;
        HashMap<String, String> properties = new HashMap<String, String>();
        for (AnnotationEntry annotationEntry : annotationEntries = this.javaClass.getAnnotationEntries()) {
            if (STRUCTURIZR_PROPERTY_ANNOTATION.equals(annotationEntry.getAnnotationType())) {
                String name = annotationEntry.getElementValuePairs()[0].getValue().stringifyValue();
                String value = annotationEntry.getElementValuePairs()[1].getValue().stringifyValue();
                properties.put(name, value);
                continue;
            }
            if (!STRUCTURIZR_PROPERTIES_ANNOTATION.equals(annotationEntry.getAnnotationType())) continue;
            ArrayElementValue arrayElementValue = (ArrayElementValue)annotationEntry.getElementValuePairs()[0].getValue();
            for (ElementValue elementValue : arrayElementValue.getElementValuesArray()) {
                AnnotationElementValue annotationElementValue = (AnnotationElementValue)elementValue;
                AnnotationEntry tagAannotationEntry = annotationElementValue.getAnnotationEntry();
                String name = tagAannotationEntry.getElementValuePairs()[0].getValue().stringifyValue();
                String value = tagAannotationEntry.getElementValuePairs()[1].getValue().stringifyValue();
                properties.put(name, value);
            }
        }
        return properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type type = (Type)o;
        return this.fullyQualifiedName.equals(type.fullyQualifiedName);
    }

    public int hashCode() {
        return Objects.hash(this.fullyQualifiedName);
    }

    public String toString() {
        return this.fullyQualifiedName;
    }

    public boolean implementsInterface(Type type) {
        if (this.javaClass != null) {
            try {
                return this.javaClass.implementationOf(type.javaClass);
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)e);
            }
        }
        return false;
    }
}

