/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component;

import com.structurizr.component.Type;
import java.util.LinkedHashSet;
import java.util.Set;

public final class TypeRepository {
    private final Set<Type> types = new LinkedHashSet<Type>();

    public void add(Type type) {
        Type t = this.getType(type.getFullyQualifiedName());
        if (t == null) {
            this.types.add(type);
        } else if (type.getJavaClass() != null) {
            t.setJavaClass(type.getJavaClass());
        } else {
            t.setDescription(type.getDescription());
            t.setSource(type.getSource());
        }
    }

    public Set<Type> getTypes() {
        return new LinkedHashSet<Type>(this.types);
    }

    Type getType(String fullyQualifiedClassName) {
        return this.types.stream().filter(t -> t.getFullyQualifiedName().equals(fullyQualifiedClassName)).findFirst().orElse(null);
    }
}

