/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.provider;

import com.structurizr.component.Type;
import com.structurizr.component.provider.TypeProvider;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClassDirectoryTypeProvider
implements TypeProvider {
    private static final Log log = LogFactory.getLog(ClassDirectoryTypeProvider.class);
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final File directory;

    public ClassDirectoryTypeProvider(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("A directory must be supplied");
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory.getAbsolutePath() + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory");
        }
        this.directory = directory;
    }

    @Override
    public Set<Type> getTypes() {
        LinkedHashSet<Type> types = new LinkedHashSet<Type>();
        Set<File> files = this.findClassFiles(this.directory);
        for (File file : files) {
            ClassParser parser = new ClassParser(file.getAbsolutePath());
            try {
                JavaClass javaClass = parser.parse();
                types.add(new Type(javaClass));
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
        }
        return types;
    }

    private Set<File> findClassFiles(File path) {
        LinkedHashSet<File> classFiles = new LinkedHashSet<File>();
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            if (files != null) {
                for (File file : files) {
                    classFiles.addAll(this.findClassFiles(file));
                }
            }
        } else if (path.getName().endsWith(CLASS_FILE_EXTENSION)) {
            classFiles.add(path);
        }
        return classFiles;
    }

    public String toString() {
        return "ClassDirectoryTypeProvider{directory=" + this.directory + "}";
    }
}

