/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component;

import com.structurizr.component.ComponentFinder;
import com.structurizr.component.ComponentFinderStrategy;
import com.structurizr.component.filter.DefaultTypeFilter;
import com.structurizr.component.filter.TypeFilter;
import com.structurizr.component.provider.ClassDirectoryTypeProvider;
import com.structurizr.component.provider.ClassJarFileTypeProvider;
import com.structurizr.component.provider.SourceDirectoryTypeProvider;
import com.structurizr.component.provider.TypeProvider;
import com.structurizr.model.Container;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ComponentFinderBuilder {
    private static final String JAR_FILE_EXTENSION = ".jar";
    private Container container;
    private final List<TypeProvider> typeProviders = new ArrayList<TypeProvider>();
    private TypeFilter typeFilter;
    private final List<ComponentFinderStrategy> componentFinderStrategies = new ArrayList<ComponentFinderStrategy>();

    public ComponentFinderBuilder forContainer(Container container) {
        this.container = container;
        return this;
    }

    public ComponentFinderBuilder fromClasses(String path) {
        return this.fromClasses(new File(path));
    }

    public ComponentFinderBuilder fromClasses(File path) {
        if (!path.exists()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " does not exist");
        }
        if (path.isDirectory()) {
            this.typeProviders.add(new ClassDirectoryTypeProvider(path));
        } else if (path.getName().endsWith(JAR_FILE_EXTENSION)) {
            this.typeProviders.add(new ClassJarFileTypeProvider(path));
        } else {
            throw new IllegalArgumentException("Expected a directory of classes or a .jar file: " + path.getAbsolutePath());
        }
        return this;
    }

    public ComponentFinderBuilder fromSource(String path) {
        return this.fromSource(new File(path));
    }

    public ComponentFinderBuilder fromSource(File path) {
        this.typeProviders.add(new SourceDirectoryTypeProvider(path));
        return this;
    }

    public ComponentFinderBuilder filteredBy(TypeFilter typeFilter) {
        this.typeFilter = typeFilter;
        return this;
    }

    public ComponentFinderBuilder withStrategy(ComponentFinderStrategy componentFinderStrategy) {
        this.componentFinderStrategies.add(componentFinderStrategy);
        return this;
    }

    public ComponentFinder build() {
        if (this.container == null) {
            throw new RuntimeException("A container must be specified");
        }
        if (this.typeProviders.isEmpty()) {
            throw new RuntimeException("One or more type providers must be configured");
        }
        if (this.typeFilter == null) {
            this.typeFilter = new DefaultTypeFilter();
        }
        if (this.componentFinderStrategies.isEmpty()) {
            throw new RuntimeException("One or more component finder strategies must be configured");
        }
        return new ComponentFinder(this.container, this.typeFilter, this.typeProviders, this.componentFinderStrategies);
    }

    public String toString() {
        return "ComponentFinderBuilder{container=" + this.container + ", typeProviders=" + this.typeProviders + ", typeFilter=" + this.typeFilter + ", componentFinderStrategies=" + this.componentFinderStrategies + "}";
    }
}

