/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component;

import com.structurizr.component.DiscoveredComponent;
import com.structurizr.component.Type;
import com.structurizr.component.TypeRepository;
import com.structurizr.component.description.DescriptionStrategy;
import com.structurizr.component.filter.TypeFilter;
import com.structurizr.component.matcher.TypeMatcher;
import com.structurizr.component.naming.NamingStrategy;
import com.structurizr.component.supporting.SupportingTypesStrategy;
import com.structurizr.component.url.UrlStrategy;
import com.structurizr.component.visitor.ComponentVisitor;
import com.structurizr.model.Component;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ComponentFinderStrategy {
    private static final Log log = LogFactory.getLog(ComponentFinderStrategy.class);
    private final String technology;
    private final TypeMatcher typeMatcher;
    private final TypeFilter typeFilter;
    private final SupportingTypesStrategy supportingTypesStrategy;
    private final NamingStrategy namingStrategy;
    private final DescriptionStrategy descriptionStrategy;
    private final UrlStrategy urlStrategy;
    private final ComponentVisitor componentVisitor;

    ComponentFinderStrategy(String technology, TypeMatcher typeMatcher, TypeFilter typeFilter, SupportingTypesStrategy supportingTypesStrategy, NamingStrategy namingStrategy, DescriptionStrategy descriptionStrategy, UrlStrategy urlStrategy, ComponentVisitor componentVisitor) {
        this.technology = technology;
        this.typeMatcher = typeMatcher;
        this.typeFilter = typeFilter;
        this.supportingTypesStrategy = supportingTypesStrategy;
        this.namingStrategy = namingStrategy;
        this.descriptionStrategy = descriptionStrategy;
        this.urlStrategy = urlStrategy;
        this.componentVisitor = componentVisitor;
    }

    Set<DiscoveredComponent> run(TypeRepository typeRepository) {
        LinkedHashSet<DiscoveredComponent> components = new LinkedHashSet<DiscoveredComponent>();
        log.debug((Object)("Running " + this.toString()));
        Set<Type> types = typeRepository.getTypes();
        for (Type type : types) {
            boolean matched = this.typeMatcher.matches(type);
            boolean accepted = this.typeFilter.accept(type);
            if (matched) {
                if (accepted) {
                    log.debug((Object)(" + " + type.getFullyQualifiedName() + " (matched=true, accepted=true)"));
                } else {
                    log.debug((Object)(" - " + type.getFullyQualifiedName() + " (matched=true, accepted=false)"));
                }
            } else {
                log.debug((Object)(" - " + type.getFullyQualifiedName() + " (matched=false)"));
            }
            if (!matched || !accepted) continue;
            DiscoveredComponent component = new DiscoveredComponent(this.namingStrategy.nameOf(type), type);
            component.setDescription(this.descriptionStrategy.descriptionOf(type));
            component.setTechnology(this.technology);
            component.setUrl(this.urlStrategy.urlOf(type));
            component.addTags(type.getTags());
            Map<String, String> properties = type.getProperties();
            for (String name : properties.keySet()) {
                component.addProperty(name, properties.get(name));
            }
            component.setComponentFinderStrategy(this);
            components.add(component);
            Set<Type> supportingTypes = this.supportingTypesStrategy.findSupportingTypes(type, typeRepository);
            if (supportingTypes.isEmpty()) {
                log.debug((Object)"   - none");
                continue;
            }
            for (Type supportingType : supportingTypes) {
                log.debug((Object)("   + supporting type: " + supportingType.getFullyQualifiedName()));
            }
            component.addSupportingTypes(supportingTypes);
        }
        return components;
    }

    void visit(Component component) {
        this.componentVisitor.visit(component);
    }

    public String toString() {
        return "ComponentFinderStrategy{technology=" + (this.technology == null ? null : "'" + this.technology + "'") + ", typeMatcher=" + this.typeMatcher + ", typeFilter=" + this.typeFilter + ", supportingTypesStrategy=" + this.supportingTypesStrategy + ", namingStrategy=" + this.namingStrategy + ", descriptionStrategy=" + this.descriptionStrategy + ", urlStrategy=" + this.urlStrategy + ", componentVisitor=" + this.componentVisitor + "}";
    }
}

