/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component;

import com.structurizr.component.ComponentFinderStrategy;
import com.structurizr.component.description.DefaultDescriptionStrategy;
import com.structurizr.component.description.DescriptionStrategy;
import com.structurizr.component.filter.DefaultTypeFilter;
import com.structurizr.component.filter.TypeFilter;
import com.structurizr.component.matcher.TypeMatcher;
import com.structurizr.component.naming.DefaultNamingStrategy;
import com.structurizr.component.naming.NamingStrategy;
import com.structurizr.component.supporting.DefaultSupportingTypesStrategy;
import com.structurizr.component.supporting.SupportingTypesStrategy;
import com.structurizr.component.url.DefaultUrlStrategy;
import com.structurizr.component.url.UrlStrategy;
import com.structurizr.component.visitor.ComponentVisitor;
import com.structurizr.component.visitor.DefaultComponentVisitor;
import com.structurizr.util.StringUtils;

public final class ComponentFinderStrategyBuilder {
    private TypeMatcher typeMatcher;
    private TypeFilter typeFilter;
    private SupportingTypesStrategy supportingTypesStrategy;
    private NamingStrategy namingStrategy;
    private DescriptionStrategy descriptionStrategy;
    private String technology;
    private UrlStrategy urlStrategy;
    private ComponentVisitor componentVisitor;

    public ComponentFinderStrategyBuilder matchedBy(TypeMatcher typeMatcher) {
        if (typeMatcher == null) {
            throw new IllegalArgumentException("A type matcher must be provided");
        }
        if (this.typeMatcher != null) {
            throw new IllegalArgumentException("A type matcher has already been configured");
        }
        this.typeMatcher = typeMatcher;
        return this;
    }

    public ComponentFinderStrategyBuilder filteredBy(TypeFilter typeFilter) {
        if (typeFilter == null) {
            throw new IllegalArgumentException("A type filter must be provided");
        }
        if (this.typeFilter != null) {
            throw new IllegalArgumentException("A type filter has already been configured");
        }
        this.typeFilter = typeFilter;
        return this;
    }

    public ComponentFinderStrategyBuilder supportedBy(SupportingTypesStrategy supportingTypesStrategy) {
        if (supportingTypesStrategy == null) {
            throw new IllegalArgumentException("A supporting types strategy must be provided");
        }
        if (this.supportingTypesStrategy != null) {
            throw new IllegalArgumentException("A supporting types strategy has already been configured");
        }
        this.supportingTypesStrategy = supportingTypesStrategy;
        return this;
    }

    public ComponentFinderStrategyBuilder withName(NamingStrategy namingStrategy) {
        if (namingStrategy == null) {
            throw new IllegalArgumentException("A naming strategy must be provided");
        }
        if (this.namingStrategy != null) {
            throw new IllegalArgumentException("A naming strategy has already been configured");
        }
        this.namingStrategy = namingStrategy;
        return this;
    }

    public ComponentFinderStrategyBuilder withDescription(DescriptionStrategy descriptionStrategy) {
        if (descriptionStrategy == null) {
            throw new IllegalArgumentException("A description strategy must be provided");
        }
        if (this.descriptionStrategy != null) {
            throw new IllegalArgumentException("A description strategy has already been configured");
        }
        this.descriptionStrategy = descriptionStrategy;
        return this;
    }

    public ComponentFinderStrategyBuilder withTechnology(String technology) {
        if (StringUtils.isNullOrEmpty((String)technology)) {
            throw new IllegalArgumentException("A technology must be provided");
        }
        if (!StringUtils.isNullOrEmpty((String)this.technology)) {
            throw new IllegalArgumentException("A technology has already been configured");
        }
        this.technology = technology;
        return this;
    }

    public ComponentFinderStrategyBuilder withUrl(UrlStrategy urlStrategy) {
        if (urlStrategy == null) {
            throw new IllegalArgumentException("A URL strategy must be provided");
        }
        if (this.urlStrategy != null) {
            throw new IllegalArgumentException("A url strategy has already been configured");
        }
        this.urlStrategy = urlStrategy;
        return this;
    }

    public ComponentFinderStrategyBuilder forEach(ComponentVisitor componentVisitor) {
        if (componentVisitor == null) {
            throw new IllegalArgumentException("A component visitor must be provided");
        }
        if (this.componentVisitor != null) {
            throw new IllegalArgumentException("A component visitor has already been configured");
        }
        this.componentVisitor = componentVisitor;
        return this;
    }

    public ComponentFinderStrategy build() {
        if (this.typeMatcher == null) {
            throw new RuntimeException("A type matcher must be provided");
        }
        if (this.typeFilter == null) {
            this.typeFilter = new DefaultTypeFilter();
        }
        if (this.supportingTypesStrategy == null) {
            this.supportingTypesStrategy = new DefaultSupportingTypesStrategy();
        }
        if (this.namingStrategy == null) {
            this.namingStrategy = new DefaultNamingStrategy();
        }
        if (this.descriptionStrategy == null) {
            this.descriptionStrategy = new DefaultDescriptionStrategy();
        }
        if (this.urlStrategy == null) {
            this.urlStrategy = new DefaultUrlStrategy();
        }
        if (this.componentVisitor == null) {
            this.componentVisitor = new DefaultComponentVisitor();
        }
        return new ComponentFinderStrategy(this.technology, this.typeMatcher, this.typeFilter, this.supportingTypesStrategy, this.namingStrategy, this.descriptionStrategy, this.urlStrategy, this.componentVisitor);
    }

    public String toString() {
        return "ComponentFinderStrategyBuilder{technology=" + (this.technology == null ? null : "'" + this.technology + "'") + ", typeMatcher=" + this.typeMatcher + ", typeFilter=" + this.typeFilter + ", supportingTypesStrategy=" + this.supportingTypesStrategy + ", namingStrategy=" + this.namingStrategy + ", descriptionStrategy=" + this.descriptionStrategy + ", urlStrategy=" + this.urlStrategy + ", componentVisitor=" + this.componentVisitor + "}";
    }
}

