/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.description;

import com.structurizr.component.Type;
import com.structurizr.component.description.DescriptionStrategy;
import com.structurizr.util.StringUtils;

public class TruncatedDescriptionStrategy
implements DescriptionStrategy {
    private final int maxLength;

    public TruncatedDescriptionStrategy(int maxLength) {
        if (maxLength < 1) {
            throw new IllegalArgumentException("Max length must be greater than 0");
        }
        this.maxLength = maxLength;
    }

    @Override
    public String descriptionOf(Type type) {
        String description = type.getDescription();
        if (StringUtils.isNullOrEmpty((String)description)) {
            return description;
        }
        if (description.length() > this.maxLength) {
            return description.substring(0, this.maxLength) + "...";
        }
        return description;
    }

    public String toString() {
        return "TruncatedDescriptionStrategy{maxLength=" + this.maxLength + "}";
    }
}

