/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.matcher;

import com.structurizr.component.Type;
import com.structurizr.component.matcher.TypeMatcher;
import com.structurizr.util.StringUtils;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtendsTypeMatcher
implements TypeMatcher {
    private static final Log log = LogFactory.getLog(ExtendsTypeMatcher.class);
    private final String className;

    public ExtendsTypeMatcher(String className) {
        if (StringUtils.isNullOrEmpty((String)className)) {
            throw new IllegalArgumentException("A fully qualified class name must be supplied");
        }
        this.className = className;
    }

    @Override
    public boolean matches(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("A type must be specified");
        }
        if (type.getJavaClass() == null) {
            return false;
        }
        JavaClass javaClass = type.getJavaClass();
        try {
            Set superClasses = Stream.of(javaClass.getSuperClasses()).map(JavaClass::getClassName).collect(Collectors.toSet());
            return superClasses.contains(this.className);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Cannot find super classes of " + type.getFullyQualifiedName()), (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return "ExtendsTypeMatcher{className='" + this.className + "'}";
    }
}

