/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.matcher;

import com.structurizr.component.Type;
import com.structurizr.component.matcher.TypeMatcher;
import com.structurizr.util.StringUtils;

public class NameSuffixTypeMatcher
implements TypeMatcher {
    private final String suffix;

    public NameSuffixTypeMatcher(String suffix) {
        if (StringUtils.isNullOrEmpty((String)suffix)) {
            throw new IllegalArgumentException("A suffix must be supplied");
        }
        this.suffix = suffix;
    }

    @Override
    public boolean matches(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("A type must be specified");
        }
        return type.getFullyQualifiedName().endsWith(this.suffix);
    }

    public String toString() {
        return "NameSuffixTypeMatcher{suffix='" + this.suffix + "'}";
    }
}

