/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.matcher;

import com.structurizr.component.Type;
import com.structurizr.component.matcher.TypeMatcher;
import com.structurizr.util.StringUtils;
import java.util.regex.Pattern;

public class RegexTypeMatcher
implements TypeMatcher {
    private final Pattern regex;

    public RegexTypeMatcher(String regex) {
        if (StringUtils.isNullOrEmpty((String)regex)) {
            throw new IllegalArgumentException("A regex must be supplied");
        }
        this.regex = Pattern.compile(regex);
    }

    @Override
    public boolean matches(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("A type must be specified");
        }
        return Pattern.matches(this.regex.pattern(), type.getFullyQualifiedName());
    }

    public String toString() {
        return "RegexTypeMatcher{regex='" + this.regex + "'}";
    }
}

