/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.supporting;

import com.structurizr.component.Type;
import com.structurizr.component.TypeRepository;
import com.structurizr.component.supporting.SupportingTypesStrategy;
import java.util.Set;
import java.util.stream.Collectors;

public class ImplementationWithPrefixSupportingTypesStrategy
implements SupportingTypesStrategy {
    private final String prefix;

    public ImplementationWithPrefixSupportingTypesStrategy(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Set<Type> findSupportingTypes(Type type, TypeRepository typeRepository) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException("The type " + type.getFullyQualifiedName() + " is not an interface");
        }
        return typeRepository.getTypes().stream().filter(dependency -> dependency.implementsInterface(type) && dependency.getName().equals(this.prefix + type.getName())).collect(Collectors.toSet());
    }

    public String toString() {
        return "ImplementationWithPrefixSupportingTypesStrategy{prefix='" + this.prefix + "'}";
    }
}

