/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.component.supporting;

import com.structurizr.component.Type;
import com.structurizr.component.TypeRepository;
import com.structurizr.component.supporting.SupportingTypesStrategy;
import java.util.Set;
import java.util.stream.Collectors;

public class ImplementationWithSuffixSupportingTypesStrategy
implements SupportingTypesStrategy {
    private final String suffix;

    public ImplementationWithSuffixSupportingTypesStrategy(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public Set<Type> findSupportingTypes(Type type, TypeRepository typeRepository) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException("The type " + type.getFullyQualifiedName() + " is not an interface");
        }
        return typeRepository.getTypes().stream().filter(dependency -> dependency.implementsInterface(type) && dependency.getName().equals(type.getName() + this.suffix)).collect(Collectors.toSet());
    }

    public String toString() {
        return "ImplementationWithSuffixSupportingTypesStrategy{suffix='" + this.suffix + "'}";
    }
}

