/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

class JavadocCommentFilter {
    private Integer maxCommentLength;

    JavadocCommentFilter(Integer maxCommentLength) {
        if (maxCommentLength != null && maxCommentLength < 1) {
            throw new IllegalArgumentException("Maximum comment length must be greater than 0.");
        }
        this.maxCommentLength = maxCommentLength;
    }

    String filterAndTruncate(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\n", " ");
        s = s.replaceAll("(?s)<.*?>", "");
        s = s.replaceAll("\\{@link (\\S*)\\}", "$1");
        s = s.replaceAll("\\{@link (\\S*) (.*?)\\}", "$2");
        if (this.maxCommentLength != null && s.length() > this.maxCommentLength) {
            return s.substring(0, this.maxCommentLength - 3) + "...";
        }
        return s;
    }
}

