/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.AbstractComponentFinderStrategy;
import com.structurizr.analysis.SupportingTypesStrategy;
import com.structurizr.analysis.TypeMatcher;
import com.structurizr.model.Component;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TypeMatcherComponentFinderStrategy
extends AbstractComponentFinderStrategy {
    private List<TypeMatcher> typeMatchers = new LinkedList<TypeMatcher>();

    public TypeMatcherComponentFinderStrategy(TypeMatcher ... typeMatchers) {
        super(new SupportingTypesStrategy[0]);
        this.typeMatchers.addAll(Arrays.asList(typeMatchers));
    }

    @Override
    protected Set<Component> doFindComponents() throws Exception {
        HashSet<Component> components = new HashSet<Component>();
        Set<Class<?>> types = this.getTypeRepository().getAllTypes();
        for (Class<?> type : types) {
            for (TypeMatcher typeMatcher : this.typeMatchers) {
                if (!typeMatcher.matches(type)) continue;
                Component component = this.getComponentFinder().getContainer().addComponent(type.getSimpleName(), type.getCanonicalName(), typeMatcher.getDescription(), typeMatcher.getTechnology());
                components.add(component);
            }
        }
        return components;
    }
}

