/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.documentation;

import com.structurizr.documentation.Format;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class FormatFinder {
    private static Set<String> MARKDOWN_EXTENSIONS = new HashSet<String>(Arrays.asList(".md", ".markdown", ".text"));
    private static Set<String> ASCIIDOC_EXTENSIONS = new HashSet<String>(Arrays.asList(".asciidoc", ".adoc", ".asc"));

    FormatFinder() {
    }

    static Format findFormat(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A file must be specified.");
        }
        String extension = file.getName().substring(file.getName().lastIndexOf("."));
        if (MARKDOWN_EXTENSIONS.contains(extension)) {
            return Format.Markdown;
        }
        if (ASCIIDOC_EXTENSIONS.contains(extension)) {
            return Format.AsciiDoc;
        }
        return Format.Markdown;
    }
}

