/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.plantuml;

import com.structurizr.Workspace;
import com.structurizr.io.WorkspaceWriter;
import com.structurizr.io.WorkspaceWriterException;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Location;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.EnterpriseContextView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.View;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;

public final class PlantUMLWriter
implements WorkspaceWriter {
    @Override
    public void write(Workspace workspace, Writer writer) throws WorkspaceWriterException {
        if (workspace != null && writer != null) {
            workspace.getViews().getEnterpriseContextViews().forEach(v -> this.write((EnterpriseContextView)v, writer));
            workspace.getViews().getSystemContextViews().forEach(v -> this.write((SystemContextView)v, writer));
            workspace.getViews().getContainerViews().forEach(v -> this.write((ContainerView)v, writer));
            workspace.getViews().getComponentViews().forEach(v -> this.write((ComponentView)v, writer));
            workspace.getViews().getDynamicViews().forEach(v -> this.write((DynamicView)v, writer));
            workspace.getViews().getDeploymentViews().forEach(v -> this.write((DeploymentView)v, writer));
        }
    }

    public void write(View view, Writer writer) {
        if (view != null && writer != null) {
            if (EnterpriseContextView.class.isAssignableFrom(view.getClass())) {
                this.write((EnterpriseContextView)view, writer);
            } else if (SystemContextView.class.isAssignableFrom(view.getClass())) {
                this.write((SystemContextView)view, writer);
            } else if (ContainerView.class.isAssignableFrom(view.getClass())) {
                this.write((ContainerView)view, writer);
            } else if (ComponentView.class.isAssignableFrom(view.getClass())) {
                this.write((ComponentView)view, writer);
            } else if (DynamicView.class.isAssignableFrom(view.getClass())) {
                this.write((DynamicView)view, writer);
            } else if (DeploymentView.class.isAssignableFrom(view.getClass())) {
                this.write((DeploymentView)view, writer);
            }
        }
    }

    private void write(EnterpriseContextView view, Writer writer) {
        try {
            this.writeHeader(view, writer);
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Person && ((Person)e).getLocation() == Location.External).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((Element)e, writer, false));
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof SoftwareSystem && ((SoftwareSystem)e).getLocation() == Location.External).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((Element)e, writer, false));
            writer.write("package " + this.nameOf(view.getModel().getEnterprise().getName()) + " {");
            writer.write(System.lineSeparator());
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof Person && ((Person)e).getLocation() == Location.Internal).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((Element)e, writer, true));
            view.getElements().stream().map(ElementView::getElement).filter(e -> e instanceof SoftwareSystem && ((SoftwareSystem)e).getLocation() == Location.Internal).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((Element)e, writer, true));
            writer.write("}");
            writer.write(System.lineSeparator());
            this.write(view.getRelationships(), writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private void write(SystemContextView view, Writer writer) {
        try {
            this.writeHeader(view, writer);
            view.getElements().stream().map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((Element)e, writer, false));
            this.write(view.getRelationships(), writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private void write(ContainerView view, Writer writer) {
        try {
            this.writeHeader(view, writer);
            view.getElements().stream().filter(ev -> !(ev.getElement() instanceof Container)).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((Element)e, writer, false));
            writer.write("package " + this.nameOf(view.getSoftwareSystem()) + " {");
            writer.write(System.lineSeparator());
            view.getElements().stream().filter(ev -> ev.getElement() instanceof Container).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((Element)e, writer, true));
            writer.write("}");
            writer.write(System.lineSeparator());
            this.write(view.getRelationships(), writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private void write(ComponentView view, Writer writer) {
        try {
            this.writeHeader(view, writer);
            view.getElements().stream().filter(ev -> !(ev.getElement() instanceof Component)).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((Element)e, writer, false));
            writer.write("package " + this.nameOf(view.getContainer()) + " {");
            writer.write(System.lineSeparator());
            view.getElements().stream().filter(ev -> ev.getElement() instanceof Component).map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((Element)e, writer, true));
            writer.write("}");
            writer.write(System.lineSeparator());
            this.write(view.getRelationships(), writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private void write(DynamicView view, Writer writer) {
        try {
            this.writeHeader(view, writer);
            view.getElements().stream().map(ElementView::getElement).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((Element)e, writer, false));
            view.getRelationships().stream().sorted((rv1, rv2) -> rv1.getOrder().compareTo(rv2.getOrder())).forEach(relationship -> {
                try {
                    writer.write(String.format("%s -> %s : %s", this.idOf(relationship.getRelationship().getSource()), this.idOf(relationship.getRelationship().getDestination()), this.hasValue(relationship.getDescription()) ? relationship.getDescription() : (this.hasValue(relationship.getRelationship().getDescription()) ? relationship.getRelationship().getDescription() : "")));
                    writer.write(System.lineSeparator());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private void write(DeploymentView view, Writer writer) {
        try {
            this.writeHeader(view, writer);
            view.getElements().stream().filter(ev -> ev.getElement() instanceof DeploymentNode && ev.getElement().getParent() == null).map(ev -> (DeploymentNode)ev.getElement()).sorted((e1, e2) -> e1.getName().compareTo(e2.getName())).forEach(e -> this.write((DeploymentNode)e, writer, 0));
            this.write(view.getRelationships(), writer);
            this.writeFooter(writer);
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private void write(DeploymentNode deploymentNode, Writer writer, int indent) {
        try {
            writer.write(String.format("%snode \"%s\" <<%s>> as %s {", this.calculateIndent(indent), deploymentNode.getName() + (deploymentNode.getInstances() > 1 ? " (x" + deploymentNode.getInstances() + ")" : ""), this.typeOf(deploymentNode), this.idOf(deploymentNode)));
            writer.write(System.lineSeparator());
            for (DeploymentNode child : deploymentNode.getChildren()) {
                this.write(child, writer, indent + 1);
            }
            for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
                this.write(containerInstance, writer, indent + 1);
            }
            writer.write(String.format("%s}", this.calculateIndent(indent)));
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(ContainerInstance containerInstance, Writer writer, int indent) {
        try {
            writer.write(String.format("%sartifact \"%s\" <<%s>> as %s", this.calculateIndent(indent), containerInstance.getContainer().getName(), this.typeOf(containerInstance), this.idOf(containerInstance)));
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String calculateIndent(int indent) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            buf.append("  ");
        }
        return buf.toString();
    }

    private void write(Element element, Writer writer, boolean indent) {
        try {
            writer.write(String.format("%s%s \"%s\" <<%s>> as %s", indent ? "  " : "", element instanceof Person ? "actor" : "component", element.getName(), this.typeOf(element), this.idOf(element)));
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(Set<RelationshipView> relationships, Writer writer) {
        relationships.stream().map(RelationshipView::getRelationship).sorted((r1, r2) -> (r1.getSource().getName() + r1.getDestination().getName()).compareTo(r2.getSource().getName() + r2.getDestination().getName())).forEach(r -> this.write((Relationship)r, writer));
    }

    private void write(Relationship relationship, Writer writer) {
        try {
            writer.write(String.format("%s ..> %s %s%s", this.idOf(relationship.getSource()), this.idOf(relationship.getDestination()), this.hasValue(relationship.getDescription()) ? ": " + relationship.getDescription() : "", this.hasValue(relationship.getTechnology()) ? " <<" + relationship.getTechnology() + ">>" : ""));
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String idOf(Element e) {
        return e.getId();
    }

    private String nameOf(Element e) {
        return this.nameOf(e.getName());
    }

    private String nameOf(String s) {
        if (s != null) {
            return s.replaceAll(" ", "").replaceAll("-", "");
        }
        return "";
    }

    private String typeOf(Element e) {
        if (e instanceof SoftwareSystem) {
            return "Software System";
        }
        if (e instanceof Component) {
            Component component = (Component)e;
            return this.hasValue(component.getTechnology()) ? component.getTechnology() : "Component";
        }
        if (e instanceof DeploymentNode) {
            DeploymentNode deploymentNode = (DeploymentNode)e;
            return this.hasValue(deploymentNode.getTechnology()) ? deploymentNode.getTechnology() : "Deployment Node";
        }
        if (e instanceof ContainerInstance) {
            return "Container";
        }
        return e.getClass().getSimpleName();
    }

    private boolean hasValue(String s) {
        return s != null && s.trim().length() > 0;
    }

    private void writeHeader(View view, Writer writer) throws IOException {
        writer.write("@startuml");
        writer.write(System.lineSeparator());
        writer.write("title " + view.getName());
        writer.write(System.lineSeparator());
        if (view.getDescription() != null && view.getDescription().trim().length() > 0) {
            writer.write("caption " + view.getDescription());
            writer.write(System.lineSeparator());
        }
    }

    private void writeFooter(Writer writer) throws IOException {
        writer.write("@enduml");
        writer.write(System.lineSeparator());
        writer.write(System.lineSeparator());
    }
}

