/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.model.Taggable;
import com.structurizr.util.Url;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class Element
extends Taggable {
    static final String CANONICAL_NAME_SEPARATOR = "/";
    private Model model;
    private String id = "";
    private String name;
    private String description;
    private String url;
    private Map<String, String> properties = new HashMap<String, String>();
    private Set<Relationship> relationships = new LinkedHashSet<Relationship>();

    protected Element() {
    }

    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    protected void setModel(Model model) {
        this.model = model;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("The name of an element must not be null or empty.");
        }
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (url != null && url.trim().length() > 0) {
            if (Url.isUrl(url)) {
                this.url = url;
            } else {
                throw new IllegalArgumentException(url + " is not a valid URL.");
            }
        }
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    public void addProperty(String name, String value) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A property name must be specified.");
        }
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException("A property value must be specified.");
        }
        this.properties.put(name, value);
    }

    void setProperties(Map<String, String> properties) {
        if (properties != null) {
            this.properties = properties;
        }
    }

    @JsonIgnore
    public abstract String getCanonicalName();

    String formatForCanonicalName(String name) {
        return name.replace(CANONICAL_NAME_SEPARATOR, "");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public abstract Element getParent();

    public Set<Relationship> getRelationships() {
        return new LinkedHashSet<Relationship>(this.relationships);
    }

    public boolean hasAfferentRelationships() {
        return this.getModel().getRelationships().stream().filter(r -> r.getDestination() == this).count() > 0L;
    }

    public boolean hasEfferentRelationshipWith(Element element) {
        return this.getEfferentRelationshipWith(element) != null;
    }

    public Relationship getEfferentRelationshipWith(Element element) {
        if (element == null) {
            return null;
        }
        for (Relationship relationship : this.relationships) {
            if (!relationship.getDestination().equals(element)) continue;
            return relationship;
        }
        return null;
    }

    boolean has(Relationship relationship) {
        return this.relationships.contains(relationship);
    }

    void addRelationship(Relationship relationship) {
        this.relationships.add(relationship);
    }

    public String toString() {
        return "{" + this.getId() + " | " + this.getName() + " | " + this.getDescription() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Element)) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Element element = (Element)o;
        return this.getCanonicalName().equals(element.getCanonicalName());
    }
}

