/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Enterprise;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.Location;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SequentialIntegerIdGeneratorStrategy;
import com.structurizr.model.SoftwareSystem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class Model {
    private SequentialIntegerIdGeneratorStrategy idGenerator = new SequentialIntegerIdGeneratorStrategy();
    private final Map<String, Element> elementsById = new HashMap<String, Element>();
    private final Map<String, Relationship> relationshipsById = new HashMap<String, Relationship>();
    private Enterprise enterprise;
    private Set<Person> people = new LinkedHashSet<Person>();
    private Set<SoftwareSystem> softwareSystems = new LinkedHashSet<SoftwareSystem>();
    private Set<DeploymentNode> deploymentNodes = new LinkedHashSet<DeploymentNode>();

    public Enterprise getEnterprise() {
        return this.enterprise;
    }

    public void setEnterprise(Enterprise enterprise) {
        this.enterprise = enterprise;
    }

    public SoftwareSystem addSoftwareSystem(String name, String description) {
        return this.addSoftwareSystem(Location.Unspecified, name, description);
    }

    public SoftwareSystem addSoftwareSystem(Location location, String name, String description) {
        if (this.getSoftwareSystemWithName(name) == null) {
            SoftwareSystem softwareSystem = new SoftwareSystem();
            softwareSystem.setLocation(location);
            softwareSystem.setName(name);
            softwareSystem.setDescription(description);
            this.softwareSystems.add(softwareSystem);
            softwareSystem.setId(this.idGenerator.generateId(softwareSystem));
            this.addElementToInternalStructures(softwareSystem);
            return softwareSystem;
        }
        throw new IllegalArgumentException("A software system named '" + name + "' already exists.");
    }

    public Person addPerson(String name, String description) {
        return this.addPerson(Location.Unspecified, name, description);
    }

    public Person addPerson(Location location, String name, String description) {
        if (this.getPersonWithName(name) == null) {
            Person person = new Person();
            person.setLocation(location);
            person.setName(name);
            person.setDescription(description);
            this.people.add(person);
            person.setId(this.idGenerator.generateId(person));
            this.addElementToInternalStructures(person);
            return person;
        }
        throw new IllegalArgumentException("A person named '" + name + "' already exists.");
    }

    Container addContainer(SoftwareSystem parent, String name, String description, String technology) {
        if (parent.getContainerWithName(name) == null) {
            Container container = new Container();
            container.setName(name);
            container.setDescription(description);
            container.setTechnology(technology);
            container.setParent(parent);
            parent.add(container);
            container.setId(this.idGenerator.generateId(container));
            this.addElementToInternalStructures(container);
            return container;
        }
        throw new IllegalArgumentException("A container named '" + name + "' already exists for this software system.");
    }

    Component addComponentOfType(Container parent, String name, String type, String description, String technology) {
        Component component = new Component();
        component.setName(name);
        component.setType(type);
        component.setDescription(description);
        component.setTechnology(technology);
        component.setParent(parent);
        parent.add(component);
        component.setId(this.idGenerator.generateId(component));
        this.addElementToInternalStructures(component);
        return component;
    }

    Component addComponent(Container parent, String name, String description) {
        Component component = new Component();
        component.setName(name);
        component.setDescription(description);
        component.setParent(parent);
        parent.add(component);
        component.setId(this.idGenerator.generateId(component));
        this.addElementToInternalStructures(component);
        return component;
    }

    Relationship addRelationship(Element source, Element destination, String description) {
        return this.addRelationship(source, destination, description, null);
    }

    Relationship addRelationship(Element source, Element destination, String description, String technology) {
        return this.addRelationship(source, destination, description, technology, InteractionStyle.Synchronous);
    }

    Relationship addRelationship(Element source, Element destination, String description, String technology, InteractionStyle interactionStyle) {
        if (destination == null) {
            throw new IllegalArgumentException("The destination must be specified.");
        }
        Relationship relationship = new Relationship(source, destination, description, technology, interactionStyle);
        if (this.addRelationship(relationship)) {
            return relationship;
        }
        return null;
    }

    private boolean addRelationship(Relationship relationship) {
        if (!relationship.getSource().has(relationship)) {
            relationship.setId(this.idGenerator.generateId(relationship));
            relationship.getSource().addRelationship(relationship);
            this.addRelationshipToInternalStructures(relationship);
            return true;
        }
        return false;
    }

    private void addElementToInternalStructures(Element element) {
        this.elementsById.put(element.getId(), element);
        element.setModel(this);
        this.idGenerator.found(element.getId());
    }

    private void addRelationshipToInternalStructures(Relationship relationship) {
        this.relationshipsById.put(relationship.getId(), relationship);
        this.idGenerator.found(relationship.getId());
    }

    @JsonIgnore
    public Set<Element> getElements() {
        return new HashSet<Element>(this.elementsById.values());
    }

    public Element getElement(String id) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("An ID must be specified.");
        }
        return this.elementsById.get(id);
    }

    @JsonIgnore
    public Set<Relationship> getRelationships() {
        return new HashSet<Relationship>(this.relationshipsById.values());
    }

    public Relationship getRelationship(String id) {
        return this.relationshipsById.get(id);
    }

    public Collection<Person> getPeople() {
        return new LinkedHashSet<Person>(this.people);
    }

    public Set<SoftwareSystem> getSoftwareSystems() {
        return new LinkedHashSet<SoftwareSystem>(this.softwareSystems);
    }

    public Set<DeploymentNode> getDeploymentNodes() {
        return new LinkedHashSet<DeploymentNode>(this.deploymentNodes);
    }

    public void hydrate() {
        this.people.forEach(this::addElementToInternalStructures);
        for (SoftwareSystem softwareSystem : this.softwareSystems) {
            this.addElementToInternalStructures(softwareSystem);
            for (Container container : softwareSystem.getContainers()) {
                softwareSystem.add(container);
                this.addElementToInternalStructures(container);
                container.setParent(softwareSystem);
                for (Component component : container.getComponents()) {
                    container.add(component);
                    this.addElementToInternalStructures(component);
                    component.setParent(container);
                }
            }
        }
        this.deploymentNodes.forEach(dn -> this.hydrateDeploymentNode((DeploymentNode)dn, null));
        this.people.forEach(this::hydrateRelationships);
        for (SoftwareSystem softwareSystem : this.softwareSystems) {
            this.hydrateRelationships(softwareSystem);
            for (Container container : softwareSystem.getContainers()) {
                this.hydrateRelationships(container);
                for (Component component : container.getComponents()) {
                    this.hydrateRelationships(component);
                }
            }
        }
        this.deploymentNodes.forEach(this::hydrateDeploymentNodeRelationships);
    }

    private void hydrateDeploymentNode(DeploymentNode deploymentNode, DeploymentNode parent) {
        deploymentNode.setParent(parent);
        this.addElementToInternalStructures(deploymentNode);
        deploymentNode.getChildren().forEach(child -> this.hydrateDeploymentNode((DeploymentNode)child, deploymentNode));
        for (ContainerInstance containerInstance : deploymentNode.getContainerInstances()) {
            containerInstance.setContainer((Container)this.getElement(containerInstance.getContainerId()));
            this.addElementToInternalStructures(containerInstance);
        }
    }

    private void hydrateDeploymentNodeRelationships(DeploymentNode deploymentNode) {
        this.hydrateRelationships(deploymentNode);
        deploymentNode.getChildren().forEach(this::hydrateDeploymentNodeRelationships);
        deploymentNode.getContainerInstances().forEach(this::hydrateRelationships);
    }

    private void hydrateRelationships(Element element) {
        for (Relationship relationship : element.getRelationships()) {
            relationship.setSource(this.getElement(relationship.getSourceId()));
            relationship.setDestination(this.getElement(relationship.getDestinationId()));
            this.addRelationshipToInternalStructures(relationship);
        }
    }

    public boolean contains(Element element) {
        return this.elementsById.values().contains(element);
    }

    public SoftwareSystem getSoftwareSystemWithName(String name) {
        for (SoftwareSystem softwareSystem : this.getSoftwareSystems()) {
            if (!softwareSystem.getName().equals(name)) continue;
            return softwareSystem;
        }
        return null;
    }

    public SoftwareSystem getSoftwareSystemWithId(String id) {
        for (SoftwareSystem softwareSystem : this.getSoftwareSystems()) {
            if (!softwareSystem.getId().equals(id)) continue;
            return softwareSystem;
        }
        return null;
    }

    public Person getPersonWithName(String name) {
        for (Person person : this.getPeople()) {
            if (!person.getName().equals(name)) continue;
            return person;
        }
        return null;
    }

    public Set<Relationship> addImplicitRelationships() {
        HashSet<Relationship> implicitRelationships = new HashSet<Relationship>();
        String descriptionKey = "D";
        String technologyKey = "T";
        HashMap candidateRelationships = new HashMap();
        for (Relationship relationship : this.getRelationships()) {
            Element destination = relationship.getDestination();
            for (Element source = relationship.getSource(); source != null; source = source.getParent()) {
                while (destination != null) {
                    if (!source.hasEfferentRelationshipWith(destination) && this.propagatedRelationshipIsAllowed(source, destination)) {
                        if (!candidateRelationships.containsKey(source)) {
                            candidateRelationships.put(source, new HashMap());
                        }
                        if (!((Map)candidateRelationships.get(source)).containsKey(destination)) {
                            ((Map)candidateRelationships.get(source)).put(destination, new HashMap());
                            ((Map)((Map)candidateRelationships.get(source)).get(destination)).put(descriptionKey, new HashSet());
                            ((Map)((Map)candidateRelationships.get(source)).get(destination)).put(technologyKey, new HashSet());
                        }
                        if (relationship.getDescription() != null) {
                            ((HashSet)((Map)((Map)candidateRelationships.get(source)).get(destination)).get(descriptionKey)).add(relationship.getDescription());
                        }
                        if (relationship.getTechnology() != null) {
                            ((HashSet)((Map)((Map)candidateRelationships.get(source)).get(destination)).get(technologyKey)).add(relationship.getTechnology());
                        }
                    }
                    destination = destination.getParent();
                }
                destination = relationship.getDestination();
            }
        }
        for (Element source : candidateRelationships.keySet()) {
            for (Element destination : ((Map)candidateRelationships.get(source)).keySet()) {
                Relationship implicitRelationship;
                Set possibleDescriptions = (Set)((Map)((Map)candidateRelationships.get(source)).get(destination)).get(descriptionKey);
                Set possibleTechnologies = (Set)((Map)((Map)candidateRelationships.get(source)).get(destination)).get(technologyKey);
                String description = "";
                if (possibleDescriptions.size() == 1) {
                    description = (String)possibleDescriptions.iterator().next();
                }
                String technology = "";
                if (possibleTechnologies.size() == 1) {
                    technology = (String)possibleTechnologies.iterator().next();
                }
                if ((implicitRelationship = this.addRelationship(source, destination, description, technology)) == null) continue;
                implicitRelationships.add(implicitRelationship);
            }
        }
        return implicitRelationships;
    }

    private boolean propagatedRelationshipIsAllowed(Element source, Element destination) {
        if (source.equals(destination)) {
            return false;
        }
        if (source.getParent() != null) {
            if (destination.equals(source.getParent())) {
                return false;
            }
            if (source.getParent().getParent() != null && destination.equals(source.getParent().getParent())) {
                return false;
            }
        }
        if (destination.getParent() != null) {
            if (source.equals(destination.getParent())) {
                return false;
            }
            if (destination.getParent().getParent() != null && source.equals(destination.getParent().getParent())) {
                return false;
            }
        }
        return true;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.people.isEmpty() && this.softwareSystems.isEmpty();
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology) {
        return this.addDeploymentNode(name, description, technology, 1);
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology, int instances) {
        return this.addDeploymentNode(name, description, technology, instances, null);
    }

    public DeploymentNode addDeploymentNode(String name, String description, String technology, int instances, Map<String, String> properties) {
        return this.addDeploymentNode(null, name, description, technology, instances, properties);
    }

    DeploymentNode addDeploymentNode(DeploymentNode parent, String name, String description, String technology, int instances, Map<String, String> properties) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A name must be specified.");
        }
        if (parent == null && this.getDeploymentNodeWithName(name) == null || parent != null && parent.getDeploymentNodeWithName(name) == null) {
            DeploymentNode deploymentNode = new DeploymentNode();
            deploymentNode.setName(name);
            deploymentNode.setDescription(description);
            deploymentNode.setTechnology(technology);
            deploymentNode.setParent(parent);
            deploymentNode.setInstances(instances);
            if (properties != null) {
                deploymentNode.setProperties(properties);
            }
            if (parent == null) {
                this.deploymentNodes.add(deploymentNode);
            }
            deploymentNode.setId(this.idGenerator.generateId(deploymentNode));
            this.addElementToInternalStructures(deploymentNode);
            return deploymentNode;
        }
        throw new IllegalArgumentException("A deployment node named '" + name + "' already exists.");
    }

    public DeploymentNode getDeploymentNodeWithName(String name) {
        for (DeploymentNode deploymentNode : this.getDeploymentNodes()) {
            if (!deploymentNode.getName().equals(name)) continue;
            return deploymentNode;
        }
        return null;
    }

    ContainerInstance addContainerInstance(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("A container must be specified.");
        }
        long instanceNumber = this.getElements().stream().filter(e -> e instanceof ContainerInstance && ((ContainerInstance)e).getContainer().equals(container)).count();
        ContainerInstance containerInstance = new ContainerInstance(container, (int)(++instanceNumber));
        containerInstance.setId(this.idGenerator.generateId(containerInstance));
        Set containerInstances = this.getElements().stream().filter(e -> e instanceof ContainerInstance).map(e -> (ContainerInstance)e).collect(Collectors.toSet());
        for (ContainerInstance ci : containerInstances) {
            Container c = ci.getContainer();
            for (Relationship relationship : container.getRelationships()) {
                if (!relationship.getDestination().equals(c)) continue;
                this.addRelationship(containerInstance, ci, relationship.getDescription(), relationship.getTechnology(), relationship.getInteractionStyle());
            }
            for (Relationship relationship : c.getRelationships()) {
                if (!relationship.getDestination().equals(container)) continue;
                this.addRelationship(ci, containerInstance, relationship.getDescription(), relationship.getTechnology(), relationship.getInteractionStyle());
            }
        }
        this.addElementToInternalStructures(containerInstance);
        return containerInstance;
    }

    public Element getElementWithCanonicalName(String canonicalName) {
        if (canonicalName == null || canonicalName.trim().length() == 0) {
            throw new IllegalArgumentException("A canonical name must be specified.");
        }
        if (!canonicalName.startsWith("/")) {
            canonicalName = "/" + canonicalName;
        }
        for (Element element : this.getElements()) {
            if (!element.getCanonicalName().equals(canonicalName)) continue;
            return element;
        }
        return null;
    }
}

