/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Element;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.Taggable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public final class Relationship
extends Taggable {
    protected String id = "";
    private Element source;
    private String sourceId;
    private Element destination;
    private String destinationId;
    private String description;
    private String technology;
    private InteractionStyle interactionStyle = InteractionStyle.Synchronous;

    Relationship() {
    }

    Relationship(Element source, Element destination, String description, String technology, InteractionStyle interactionStyle) {
        this();
        this.source = source;
        this.destination = destination;
        this.description = description;
        this.technology = technology;
        this.setInteractionStyle(interactionStyle);
    }

    @JsonIgnore
    public Element getSource() {
        return this.source;
    }

    public String getSourceId() {
        if (this.source != null) {
            return this.source.getId();
        }
        return this.sourceId;
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public void setSource(Element source) {
        this.source = source;
    }

    @JsonIgnore
    public Element getDestination() {
        return this.destination;
    }

    public String getDestinationId() {
        if (this.destination != null) {
            return this.destination.getId();
        }
        return this.destinationId;
    }

    void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public void setDestination(Element destination) {
        this.destination = destination;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTechnology() {
        return this.technology;
    }

    public void setTechnology(String technology) {
        this.technology = technology;
    }

    public InteractionStyle getInteractionStyle() {
        return this.interactionStyle;
    }

    public void setInteractionStyle(InteractionStyle interactionStyle) {
        this.interactionStyle = interactionStyle;
        if (interactionStyle == InteractionStyle.Synchronous) {
            this.removeTag("Asynchronous");
            this.addTags(new String[]{"Synchronous"});
        } else {
            this.removeTag("Synchronous");
            this.addTags(new String[]{"Asynchronous"});
        }
    }

    @Override
    protected Set<String> getRequiredTags() {
        return new LinkedHashSet<String>(Arrays.asList("Relationship"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relationship that = (Relationship)o;
        if (!this.getDescription().equals(that.getDescription())) {
            return false;
        }
        if (!this.getDestination().equals(that.getDestination())) {
            return false;
        }
        return this.getSource().equals(that.getSource());
    }

    public int hashCode() {
        int result = this.getSourceId().hashCode();
        result = 31 * result + this.getDestinationId().hashCode();
        result = 31 * result + this.getDescription().hashCode();
        return result;
    }

    public String toString() {
        return this.source.toString() + " ---[" + this.description + "]---> " + this.destination.toString();
    }
}

