/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Location;
import com.structurizr.model.StaticStructureElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public final class SoftwareSystem
extends StaticStructureElement {
    private Location location = Location.Unspecified;
    private Set<Container> containers = new LinkedHashSet<Container>();

    @Override
    @JsonIgnore
    public Element getParent() {
        return null;
    }

    SoftwareSystem() {
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location != null ? location : Location.Unspecified;
    }

    void add(Container container) {
        this.containers.add(container);
    }

    public Set<Container> getContainers() {
        return new HashSet<Container>(this.containers);
    }

    public Container addContainer(String name, String description, String technology) {
        return this.getModel().addContainer(this, name, description, technology);
    }

    public Container getContainerWithName(String name) {
        for (Container container : this.getContainers()) {
            if (!container.getName().equals(name)) continue;
            return container;
        }
        return null;
    }

    public Container getContainerWithId(String id) {
        for (Container container : this.getContainers()) {
            if (!container.getId().equals(id)) continue;
            return container;
        }
        return null;
    }

    @Override
    public String getCanonicalName() {
        return "/" + this.formatForCanonicalName(this.getName());
    }

    @Override
    protected Set<String> getRequiredTags() {
        return new LinkedHashSet<String>(Arrays.asList("Element", "Software System"));
    }
}

