/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.util;

import com.structurizr.Workspace;
import com.structurizr.io.WorkspaceWriterException;
import com.structurizr.io.json.JsonReader;
import com.structurizr.io.json.JsonWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;

public final class WorkspaceUtils {
    public static Workspace loadWorkspaceFromJson(File file) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("The path to a JSON file must be specified.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("The specified JSON file does not exist.");
        }
        return new JsonReader().read(new FileReader(file));
    }

    public static void saveWorkspaceToJson(Workspace workspace, File file) throws Exception {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        if (file == null) {
            throw new IllegalArgumentException("The path to a JSON file must be specified.");
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        new JsonWriter(true).write(workspace, writer);
        writer.flush();
        writer.close();
    }

    public static void printWorkspaceAsJson(Workspace workspace) {
        try {
            JsonWriter jsonWriter = new JsonWriter(true);
            StringWriter stringWriter = new StringWriter();
            jsonWriter.write(workspace, stringWriter);
            System.out.println(stringWriter.toString());
        }
        catch (WorkspaceWriterException e) {
            e.printStackTrace();
        }
    }
}

