/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.StaticView;

public final class ContainerView
extends StaticView {
    ContainerView() {
    }

    ContainerView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
    }

    @Override
    public void add(SoftwareSystem softwareSystem) {
        if (softwareSystem != null && !softwareSystem.equals(this.getSoftwareSystem())) {
            this.addElement(softwareSystem, true);
        }
    }

    public void addAllContainers() {
        this.getSoftwareSystem().getContainers().forEach(this::add);
    }

    public void add(Container container) {
        if (container != null) {
            if (container.getParent().equals(this.getSoftwareSystem())) {
                this.addElement(container, true);
            } else {
                throw new IllegalArgumentException("Only containers belonging to " + this.getSoftwareSystem().getName() + " can be added to this view.");
            }
        }
    }

    public void remove(Container container) {
        this.removeElement(container);
    }

    @Override
    public String getName() {
        return this.getSoftwareSystem().getName() + " - Containers";
    }

    @Override
    public void addAllElements() {
        this.addAllSoftwareSystems();
        this.addAllPeople();
        this.addAllContainers();
    }

    @Override
    public void addNearestNeighbours(Element element) {
        super.addNearestNeighbours(element, SoftwareSystem.class);
        super.addNearestNeighbours(element, Person.class);
        super.addNearestNeighbours(element, Container.class);
    }
}

