/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.SequenceNumber;
import com.structurizr.view.View;
import java.util.ArrayList;
import java.util.Collections;

public final class DynamicView
extends View {
    private Model model;
    private Element element;
    private String elementId;
    private SequenceNumber sequenceNumber = new SequenceNumber();

    DynamicView() {
    }

    DynamicView(Model model, String key, String description) {
        super(null, key, description);
        this.model = model;
        this.element = null;
    }

    DynamicView(SoftwareSystem softwareSystem, String key, String description) {
        super(softwareSystem, key, description);
        this.model = softwareSystem.getModel();
        this.element = softwareSystem;
    }

    DynamicView(Container container, String key, String description) {
        super(container.getSoftwareSystem(), key, description);
        this.model = container.getModel();
        this.element = container;
    }

    @Override
    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    @Override
    @JsonIgnore
    public String getSoftwareSystemId() {
        return super.getSoftwareSystemId();
    }

    public String getElementId() {
        if (this.element != null) {
            return this.element.getId();
        }
        return this.elementId;
    }

    void setElementId(String elementId) {
        this.elementId = elementId;
    }

    @JsonIgnore
    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public RelationshipView add(Element source, Element destination) {
        return this.add(source, "", destination);
    }

    public RelationshipView add(Element source, String description, Element destination) {
        if (source != null && destination != null) {
            this.checkElement(source);
            this.checkElement(destination);
            Relationship relationship = source.getEfferentRelationshipWith(destination);
            if (relationship != null) {
                this.addElement(source, false);
                this.addElement(destination, false);
                RelationshipView relationshipView = this.addRelationship(relationship, description, this.sequenceNumber.getNext());
                return relationshipView;
            }
            throw new IllegalArgumentException("Relationship does not exist in model");
        }
        throw new IllegalArgumentException("Source and destination must not be null");
    }

    private void checkElement(Element e) {
        if (e instanceof Person) {
            return;
        }
        if (this.element instanceof SoftwareSystem) {
            if (e.equals(this.element)) {
                throw new IllegalArgumentException(e.getName() + " is already the scope of this view and cannot be added to it.");
            }
            if (e instanceof Container && !e.getParent().equals(this.element)) {
                throw new IllegalArgumentException("Only containers that reside inside " + this.element.getName() + " can be added to this view.");
            }
            if (e instanceof Component) {
                throw new IllegalArgumentException("Components can't be added to a dynamic view when the scope is a software system.");
            }
        }
        if (this.element instanceof Container) {
            if (e.equals(this.element) || e.equals(this.element.getParent())) {
                throw new IllegalArgumentException(e.getName() + " is already the scope of this view and cannot be added to it.");
            }
            if (e instanceof Container && !e.getParent().equals(this.element.getParent())) {
                throw new IllegalArgumentException("Only containers that reside inside " + this.element.getParent().getName() + " can be added to this view.");
            }
            if (e instanceof Component && !e.getParent().equals(this.element)) {
                throw new IllegalArgumentException("Only components that reside inside " + this.element.getName() + " can be added to this view.");
            }
        }
    }

    @Override
    public RelationshipView add(Relationship relationship) {
        this.addElement(relationship.getSource(), false);
        this.addElement(relationship.getDestination(), false);
        return super.add(relationship);
    }

    @Override
    protected RelationshipView findRelationshipView(RelationshipView sourceRelationshipView) {
        for (RelationshipView relationshipView : this.getRelationships()) {
            if (!relationshipView.getRelationship().equals(sourceRelationshipView.getRelationship()) || relationshipView.getDescription() == null || !relationshipView.getDescription().equals(sourceRelationshipView.getDescription()) || !relationshipView.getOrder().equals(sourceRelationshipView.getOrder())) continue;
            return relationshipView;
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.element != null) {
            return this.element.getName() + " - Dynamic";
        }
        return "Dynamic";
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        ArrayList<RelationshipView> list = new ArrayList<RelationshipView>(this.getRelationships());
        Collections.sort(list, (rv1, rv2) -> rv1.getOrder().compareTo(rv2.getOrder()));
        list.forEach(rv -> buf.append(rv.toString() + "\n"));
        return buf.toString();
    }

    public void startParallelSequence() {
        this.sequenceNumber.startParallelSequence();
    }

    public void endParallelSequence() {
        this.sequenceNumber.endParallelSequence();
    }
}

