/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.structurizr.view.Border;
import com.structurizr.view.Color;
import com.structurizr.view.Shape;

public final class ElementStyle {
    public static final int DEFAULT_WIDTH = 450;
    public static final int DEFAULT_HEIGHT = 300;
    private String tag;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer width;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer height;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String background;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String color;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer fontSize;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Shape shape;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Border border;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer opacity;

    ElementStyle() {
    }

    ElementStyle(String tag) {
        this.tag = tag;
    }

    public ElementStyle(String tag, Integer width, Integer height, String background, String color, Integer fontSize) {
        this(tag, width, height, background, color, fontSize, null);
    }

    public ElementStyle(String tag, Integer width, Integer height, String background, String color, Integer fontSize, Shape shape) {
        this.tag = tag;
        this.width = width;
        this.height = height;
        this.setBackground(background);
        this.setColor(color);
        this.fontSize = fontSize;
        this.shape = shape;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public ElementStyle width(int width) {
        this.setWidth(width);
        return this;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public ElementStyle height(int height) {
        this.setHeight(height);
        return this;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        if (!Color.isHexColorCode(background)) {
            throw new IllegalArgumentException(background + " is not a valid hex colour code.");
        }
        this.background = background;
    }

    public ElementStyle background(String background) {
        this.setBackground(background);
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        if (!Color.isHexColorCode(color)) {
            throw new IllegalArgumentException(color + " is not a valid hex colour code.");
        }
        this.color = color;
    }

    public ElementStyle color(String color) {
        this.setColor(color);
        return this;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public ElementStyle fontSize(int fontSize) {
        this.setFontSize(fontSize);
        return this;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public ElementStyle shape(Shape shape) {
        this.setShape(shape);
        return this;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public ElementStyle border(Border border) {
        this.setBorder(border);
        return this;
    }

    public Integer getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Integer opacity) {
        if (opacity != null) {
            this.opacity = opacity < 0 ? Integer.valueOf(0) : (opacity > 100 ? Integer.valueOf(100) : opacity);
        }
    }

    public ElementStyle opacity(int opacity) {
        this.setOpacity(opacity);
        return this;
    }
}

