/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Element;
import com.structurizr.model.Enterprise;
import com.structurizr.model.Model;
import com.structurizr.model.Person;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.StaticView;

public final class EnterpriseContextView
extends StaticView {
    private Model model;

    EnterpriseContextView() {
    }

    EnterpriseContextView(Model model, String key, String description) {
        super(null, key, description);
        this.model = model;
    }

    @Override
    public String getName() {
        Enterprise enterprise = this.model.getEnterprise();
        return "Enterprise Context" + (enterprise != null && enterprise.getName().trim().length() > 0 ? " for " + enterprise.getName() : "");
    }

    @Override
    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    @Override
    public void addAllElements() {
        this.addAllSoftwareSystems();
        this.addAllPeople();
    }

    @Override
    public void addNearestNeighbours(Element element) {
        super.addNearestNeighbours(element, SoftwareSystem.class);
        super.addNearestNeighbours(element, Person.class);
    }
}

