/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.Relationship;
import com.structurizr.view.Vertex;
import java.util.Collection;
import java.util.LinkedList;

public final class RelationshipView {
    private Relationship relationship;
    private String id;
    private String description;
    private String order;
    private Collection<Vertex> vertices = new LinkedList<Vertex>();

    RelationshipView() {
    }

    RelationshipView(Relationship relationship) {
        this.relationship = relationship;
    }

    public String getId() {
        if (this.relationship != null) {
            return this.relationship.getId();
        }
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    public Relationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public Collection<Vertex> getVertices() {
        return this.vertices;
    }

    public void setVertices(Collection<Vertex> vertices) {
        this.vertices = vertices;
    }

    void copyLayoutInformationFrom(RelationshipView source) {
        if (source != null) {
            this.setVertices(source.getVertices());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipView that = (RelationshipView)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.getId().equals(that.getId())) {
            return false;
        }
        return !(this.order != null ? !this.order.equals(that.order) : that.order != null);
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.relationship != null) {
            return (this.order != null ? this.order + ": " : "") + (this.description != null ? this.description + " " : "") + this.relationship.toString();
        }
        return "";
    }
}

