/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

abstract class ModelItem {
    private String id = "";
    private Set<String> tags = new LinkedHashSet<String>();
    private Map<String, String> properties = new HashMap<String, String>();

    ModelItem() {
    }

    protected abstract Set<String> getRequiredTags();

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getTags() {
        Set<String> setOfTags = this.getTagsAsSet();
        if (setOfTags.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String tag : setOfTags) {
            buf.append(tag);
            buf.append(",");
        }
        String tagsAsString = buf.toString();
        return tagsAsString.substring(0, tagsAsString.length() - 1);
    }

    @JsonIgnore
    public Set<String> getTagsAsSet() {
        LinkedHashSet<String> setOfTags = new LinkedHashSet<String>(this.getRequiredTags());
        setOfTags.addAll(this.tags);
        return setOfTags;
    }

    void setTags(String tags) {
        if (tags == null) {
            return;
        }
        this.tags.clear();
        Collections.addAll(this.tags, tags.split(","));
    }

    public void addTags(String ... tags) {
        if (tags == null) {
            return;
        }
        for (String tag : tags) {
            if (tag == null) continue;
            this.tags.add(tag);
        }
    }

    public void removeTag(String tag) {
        if (tag != null) {
            this.tags.remove(tag);
        }
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    public void addProperty(String name, String value) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A property name must be specified.");
        }
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException("A property value must be specified.");
        }
        this.properties.put(name, value);
    }

    void setProperties(Map<String, String> properties) {
        if (properties != null) {
            this.properties = new HashMap<String, String>(properties);
        }
    }
}

